% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_images.R
\name{images_generator_request}
\alias{images_generator_request}
\title{API images: create (generator) request}
\usage{
images_generator_request(
  prompt,
  model = NULL,
  n = NULL,
  quality = NULL,
  response_format = NULL,
  size = NULL,
  style = NULL,
  user = NULL,
  api_key = api_get_key()
)
}
\arguments{
\item{prompt}{string, a text description of the desired image(s). The maximum length is 1000 characters for dall-e-2
and 4000 characters for dall-e-3.}

\item{model}{NULL/string, the model to use for image generation. Defaults to `dall-e-2`}

\item{n}{NULL/int, the number of images to generate. Must be between 1 and 10. For dall-e-3, only n=1 is supported.}

\item{quality}{NULL/string, the quality of the image that will be generated. `hd` creates images with finer details
and greater consistency across the image. This param is only supported for dall-e-3. Defaults to `standard`.}

\item{response_format}{NULL/string, the format in which the generated images are returned. Must be one of "url" or
"b64_json".}

\item{size}{NULL/string, the size of the generated images. Must be one of 256x256, 512x512, or 1024x1024 for
dall-e-2. Must be one of 1024x1024, 1792x1024, or 1024x1792 for dall-e-3 models. 1024x1024 is default.}

\item{style}{NULL/string, the style of the generated images. Must be one of `vivid` (default) or `natural`. Vivid
causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more
natural, less hyper-real looking images. This param is only supported for dall-e-3.}

\item{user}{string a unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse.}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
To get more details, visit https://platform.openai.com/docs/api-reference/images/create
}
