% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windrose.R
\name{[[,windrose-method}
\alias{[[,windrose-method}
\title{Extract Something From a windrose Object}
\usage{
\S4method{[[}{windrose}(x, i, j, ...)
}
\arguments{
\item{x}{a \linkS4class{windrose} object.}

\item{i}{character value indicating the name of an item to extract.}

\item{j}{optional additional information on the \code{i} item.}

\item{...}{ignored.}
}
\description{
Generally, the \code{[[} method lets users extract information from \code{oce}
objects, without having to know the details of the internal storage.  For
many \code{oce} sub-classes, \code{[[} can also return quantities that are computed
from the object's contents.
}
\details{
A two-step process is used to try to find the requested information. First, a
class-specific function is used (see \dQuote{Details of the Specialized
Method}).  If this yields nothing, then a general method is used (see
\dQuote{Details of the General Method}).  If both methods fail, then \code{[[}
returns NULL.

Some understanding of the subclass is required to know what can be retrieved
with \code{[[}. When dealing with an unfamiliar subclass, it can be useful to
first use \code{x[["?"]]} to get a listing of the retrievable items. See
\dQuote{Details of the Specialized Method} for more information.
}
\section{Details of the Specialized Method}{

\itemize{
\item If \code{i} is \code{"?"}, then the return value is a list
containing four items, each of which is a character vector
holding the names of things that can be accessed with \code{[[}.
The \code{data} and \code{metadata} items hold the names of
entries in the object's data and metadata
slots, respectively. The \code{metadataDerived} and
\code{dataDerived} items are both NULL.
}
}

\section{Details of the General Method}{


Note: the text of this section is identical for all \code{oce} subclasses, and so
some of what you read here may not be relevant to the class being described
in this help page.

If the specialized method produces no matches, the following generalized
method is applied. As with the specialized method, the procedure hinges first
on the values of \code{i} and, optionally, \code{j}. The work proceeds in steps, by
testing a sequence of possible conditions in sequence.
\enumerate{
\item A check is made as to whether \code{i} names one of the standard \code{oce} slots.
If so, \code{[[} returns the slot contents of that slot.  Thus, \code{x[["metadata"]]}
will retrieve the \code{metadata} slot, while \code{x[["data"]]} and
\code{x[["processingLog"]]} return those slots.
\item If \code{i} is a string ending in the \code{"Unit"}, then the characters preceding
that string are taken to be the name of an item in the data object, and a
list containing the unit is returned (or \code{NULL} if there is no such unit).
This list consists of an item named \code{unit}, which is an \code{\link[=expression]{expression()}}, and
an item named \code{scale}, which is a string describing the measurement scale.
If the string ends in \code{" unit"}, e.g.  \code{x[["temperature unit"]]} (note the
space), then just the expression is returned, and if it ends in \code{" scale"},
then just the scale is returned.
\item If \code{i} is a string ending in \code{"Flag"}, then the corresponding data-quality
flag is returned (or \code{NULL} if there is no such flag).
\item If the object holds hydrographic information (pressure, salinity,
temperature, longitude and latitude) then another set of possibilities
arises.  If \code{i} is \code{"sigmaTheta"}, then the value of \code{\link[=swSigmaTheta]{swSigmaTheta()}} is
called with \code{x} as the sole argument, and the results are returned.
Similarly, \code{\link[=swSigma0]{swSigma0()}} is used if \code{i="sigma0"}, and \code{\link[=swSpice]{swSpice()}} is used if
\code{i="spice"}. Of course, these actions only make sense for objects that
contain the relevant items within their \code{data} slot.
\item After these possibilities are eliminated, the action depends on whether
\code{j} has been provided.  If \code{j} is not provided, or is the string \code{""}, then
\code{i} is sought in the \code{metadata} slot, and then in the \code{data} slot, returning
whichever is found first.  In other words, if \code{j} is not provided, the
\code{metadata} slot takes preference over the \code{data} slot. However, if \code{j} is
provided, then it must be either the string \code{"metadata"} or \code{"data"}, and it
directs where to look.
\item If none of the above-listed conditions holds, then \code{NULL} is returned.
}
}

\seealso{
Other functions that extract parts of oce objects: 
\code{\link{[[,adp-method}},
\code{\link{[[,adv-method}},
\code{\link{[[,amsr-method}},
\code{\link{[[,argo-method}},
\code{\link{[[,bremen-method}},
\code{\link{[[,cm-method}},
\code{\link{[[,coastline-method}},
\code{\link{[[,ctd-method}},
\code{\link{[[,echosounder-method}},
\code{\link{[[,g1sst-method}},
\code{\link{[[,gps-method}},
\code{\link{[[,ladp-method}},
\code{\link{[[,landsat-method}},
\code{\link{[[,lisst-method}},
\code{\link{[[,lobo-method}},
\code{\link{[[,met-method}},
\code{\link{[[,oce-method}},
\code{\link{[[,odf-method}},
\code{\link{[[,rsk-method}},
\code{\link{[[,sealevel-method}},
\code{\link{[[,section-method}},
\code{\link{[[,tidem-method}},
\code{\link{[[,topo-method}},
\code{\link{[[,xbt-method}},
\code{\link{[[<-,adv-method}}

Other things related to windrose data: 
\code{\link{[[<-,windrose-method}},
\code{\link{as.windrose}()},
\code{\link{plot,windrose-method}},
\code{\link{summary,windrose-method}},
\code{\link{windrose-class}}
}
\author{
Dan Kelley
}
\concept{functions that extract parts of oce objects}
\concept{things related to windrose data}
