% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od_coordinates}
\alias{od_coordinates}
\title{Create matrices representing origin-destination coordinates}
\usage{
od_coordinates(x, p = NULL, pd = NULL, silent = TRUE, sfnames = FALSE)
}
\arguments{
\item{x}{A data frame in which the first two columns are codes
representing points/zones of origin and destination}

\item{p}{Points representing origins and destinations}

\item{pd}{Points representing destinations, if different from origin points}

\item{silent}{Hide messages? \code{FALSE} by default.}

\item{sfnames}{Should output column names be compatible with the sf package?}
}
\value{
A data frame with origin and destination coordinates
}
\description{
This function takes an 'od data frame' with the first
two columns matching IDs of spatial objects, and
matches them with objects representing origins and destinations
in wide range of input data types (spatial lines, points or text strings).
It returns a data frame of coordinates representing movement between all origin (ox, oy) and destination (dx, dy) points.
}
\details{
See \code{\link[=points_to_od]{points_to_od()}} for a function that creates
an 'od data frame' from a set (or two sets) of points.
}
\examples{
x = od_data_df
p = od_data_centroids
res = od_coordinates(x, p)[1:2, ]
class(res)
res
od_coordinates(x, p, sfnames = TRUE)[1:2, ]
od_coordinates(x, p, silent = FALSE)[1:2, ]
od_coordinates(x, p)
x = od_data_df2[1:3, ]
p = od_data_centroids2
pd = od_data_destinations
od_coordinates(x, p, pd)
}
