% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genotype_statistics.R
\name{generate_ogrdb_report}
\alias{generate_ogrdb_report}
\title{Generate OGRDB reports from specified files.}
\usage{
generate_ogrdb_report(
  ref_filename,
  inferred_filename,
  species,
  filename,
  chain,
  hap_gene,
  segment,
  chain_type,
  plot_unmutated,
  all_inferred = FALSE,
  format = "pdf",
  custom_file_prefix = ""
)
}
\arguments{
\item{ref_filename}{Name of file containing IMGT-aligned reference genes in FASTA format}

\item{inferred_filename}{Name of file containing sequences of inferred novel alleles, or '-' if none}

\item{species}{Species name used in field 3 of the IMGT germline header with spaces omitted, if the reference file is from IMGT. Otherwise ''}

\item{filename}{Name of file containing annotated reads in AIRR, CHANGEO or IgDiscover format. The format is detected automatically}

\item{chain}{one of IGHV, IGKV, IGLV, IGHD, IGHJ, IGKJ, IGLJ, TRAV, TRAj, TRBV, TRBD, TRBJ, TRGV, TRGj, TRDV, TRDD, TRDJ}

\item{hap_gene}{The haplotyping columns will be completed based on the usage of the two most frequent alleles of this gene. If NA, the column will be blank}

\item{segment}{one of V, D, J}

\item{chain_type}{one of H, L}

\item{plot_unmutated}{Plot base composition using only unmutated sequences (V-chains only)}

\item{all_inferred}{Treat all alleles as novel}

\item{format}{The format for the plot file ('pdf', 'html' or 'none')}

\item{custom_file_prefix}{custom prefix to use for output files. If not specified, the prefix is taken from the input file name}
}
\value{
None
}
\description{
This creates the genotype report
(suffixed _ogrdb_report.csv) and the plot file (suffixed _ogrdb_plos.pdf).
Both are created in the directory holding the annotated read file, and the
file names are prefixed by the name of the annotated read file.
}
\examples{
# prepare files for example
reference_set = system.file("extdata/ref_gapped.fasta", package = "ogrdbstats")
inferred_set = system.file("extdata/novel_gapped.fasta", package = "ogrdbstats")
repertoire = system.file("extdata/ogrdbstats_example_repertoire.tsv", package = "ogrdbstats")
file.copy(repertoire, tempdir())
repfile = file.path(tempdir(), 'ogrdbstats_example_repertoire.tsv')

generate_ogrdb_report(reference_set, inferred_set, 'Homosapiens',
          repfile, 'IGHV', NA, 'V', 'H', FALSE, format='none')

#clean up
outfile = file.path(tempdir(), 'ogrdbstats_example_repertoire_ogrdb_report.csv')
file.remove(repfile)
file.remove(outfile)
}
