% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_batch_effect.R
\name{perform_batch_assessment}
\alias{perform_batch_assessment}
\title{Perform Principal Variance Component Analysis for Batch Effect Assessment}
\usage{
perform_batch_assessment(data_matrix, sample_info, batch_effects, threshold)
}
\arguments{
\item{data_matrix}{A data frame or matrix where rows represent features and columns represent samples.}

\item{sample_info}{A data frame containing sample information with rows matching the columns of `data_matrix`.}

\item{batch_effects}{A character vector of column names in `sample_info` that represent batch effects.}

\item{threshold}{A numeric value between 0 and 1 to specify the PVCA threshold.}
}
\value{
A PVCA object containing the results of the batch effect assessment.
}
\description{
This function performs Principal Variance Component Analysis to assess batch effects in the dataset.
}
\examples{
# Example data
set.seed(123)
data_matrix <- data.frame(
  sample1 = rnorm(100),
  sample2 = rnorm(100),
  sample3 = rnorm(100),
  sample4 = rnorm(100),
  sample5 = rnorm(100),
  sample6 = rnorm(100),
  sample7 = rnorm(100),
  sample8 = rnorm(100),
  sample9 = rnorm(100),
  sample10 = rnorm(100)
)
rownames(data_matrix) <- paste0("feature", 1:100)

sample_info <- data.frame(
  dose = c(0, 1, 2, 1, 0, 2, 1, 0, 2, 1),
  time = c(-1, 1, 25, -1, 1, 25, -1, 1, 25, -1),
  batch = rep(c("A", "B", "C"), length.out = 10)
)
rownames(sample_info) <- colnames(data_matrix)

# Perform Batch Effect Assessment
if (requireNamespace("Biobase", quietly = TRUE) &&
    requireNamespace("pvca", quietly = TRUE)) {
  pvca_results <- perform_batch_assessment(
    data_matrix,
    sample_info,
    c("batch", "dose", "time"),
    0.6
  )
}
}
