% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSE42861small.R
\docType{data}
\name{GSE42861small}
\alias{GSE42861small}
\title{Small Subset of GSE42861 Dataset From GEO}
\format{
An object of class \code{list} of length 4.
}
\source{
\href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE42861}{GEO}
}
\usage{
data(GSE42861small)
}
\description{
The dataset includes 336 rheumatoid arthritis cases and 322 controls.
A subset of 500 CpG sites were randomly selected from the original EWAS dataset.
}
\examples{
data(GSE42861small)
X = GSE42861small$X
W = GSE42861small$W
Y = GSE42861small$Y
Y = Y[seq(1, 20), ] # for brevity
C = GSE42861small$C
result = ctassoc(X, W, Y, C = C)
result$coefficients
}
\seealso{
ctassoc
}
\keyword{datasets}
