% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MR_2SLS.R
\name{MR_2SLS}
\alias{MR_2SLS}
\title{MR_2SLS}
\usage{
MR_2SLS(
  infile,
  outcome,
  outcome_name,
  prs_cols_match,
  regexpr_pattern,
  standardise = TRUE,
  digits = 3,
  .progress = TRUE
)
}
\arguments{
\item{infile}{The input file containing the data.}

\item{outcome}{The outcome variable.}

\item{outcome_name}{The name of the outcome variable.}

\item{prs_cols_match}{The columns to match for PRS.}

\item{regexpr_pattern}{The regular expression pattern to use for matching.}

\item{standardise}{Whether to standardise the prs data, Default: TRUE}

\item{digits}{The number of decimal places to round to, Default: 3}

\item{.progress}{Whether to show progress, Default: TRUE}
}
\value{
A list containing the results of the 2SLS analysis.
}
\description{
Perform Two-Stage Least Squares (2SLS) Mendelian Randomization analysis.
}
\details{
This function performs a Two-Stage Least Squares (2SLS) Mendelian Randomization analysis.
}
\seealso{
\code{\link[data.table]{fread}}, \code{\link[data.table]{as.data.table}}, \code{\link[data.table]{setattr}}, \code{\link[data.table]{setDT}}
\code{\link[dplyr]{select}}, \code{\link[dplyr]{reexports}}
\code{\link[purrr]{map}}
\code{\link[stringr]{str_extract}}
\code{\link[Matrix]{nearPD}}
\code{\link[corpcor]{cov.shrink}}
}
\author{
Zhen Lu \href{mailto:luzh29@mail2.sysu.edu.cn}{luzh29@mail2.sysu.edu.cn}

Siyang Liu \href{mailto:liusy99@mail.sysu.edu.cn}{liusy99@mail.sysu.edu.cn}
}
