% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_image}
\alias{filter_image}
\title{Filter: display an image}
\usage{
filter_image(image)
}
\arguments{
\item{image}{A link or path to an image resource.}
}
\value{
An \code{svg} object.
}
\description{
Display an image using a URL or a relative path to an on-disk resource.
}
\examples{
if (interactive()) {

# Place an image (obtained via an image
# link) within a rectangle element using
# the `filter_image()` filter
SVG(width = 500, height = 500) \%>\%
  svg_filter(
    id = "image",
    filters = list(
      filter_image(
        image = "https://www.r-project.org/logo/Rlogo.png"
      )
    )
  ) \%>\%
  svg_rect(
    x = 25, y = 25,
    width = "50\%", height = "50\%",
    attrs = svg_attrs_pres(filter = "image")
  )
}

}
