% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode_onemap.R
\name{geocode_onemap}
\alias{geocode_onemap}
\title{Geocode a dataframe of keywords}
\usage{
geocode_onemap(
  df,
  search_val,
  return_geom = FALSE,
  address_details = FALSE,
  return_spatial = FALSE,
  spatial_lnglat = TRUE,
  parallel = FALSE
)
}
\arguments{
\item{df}{Input tibble with column to be geocoded}

\item{search_val}{Column name containing keyword(s) to be geocoded, e.g. column of postal codes}

\item{return_geom}{Default = \code{FALSE}. Whether to return the coordinate information}

\item{address_details}{Default = \code{FALSE}. Whether to return address information}

\item{return_spatial}{Default = \code{FALSE}. Whether to return the output as an \code{sf} object. Please ensure \code{}}

\item{spatial_lnglat}{Default = \code{TRUE}. If \code{TRUE}, the WGS84 coordinates will be used to create the \code{sf} tibble. If \code{FALSE}, the SVY21 coordinates will be used.}

\item{parallel}{Default = \code{FALSE}. Whether to run API calls in parallel or sequentially (default).}
}
\value{
Please note only the top result matching the search will be returned. If no error occurs:
\describe{
\item{SEARCH_VAL}{Detailed search name}
\item{X}{Longitude in SVY21. Returned only if \code{return_geom = TRUE}}
\item{Y}{Latitude in SVY21. Returned only if \code{return_geom = TRUE}}
\item{LONGITUDE}{Longitude in WGS84. Returned only if \code{return_geom = TRUE}}
\item{LATITUDE}{Latitude in WGS84. Returned only if \code{return_geom = TRUE}}
\item{BLK_NO}{Block number}
\item{ROAD_NAME}{Road Name}
\item{BUILDING}{Building Name}
\item{ADDRESS}{Address}
\item{POSTAL}{Postal Code}
}

If an error occurs, an empty result will be returned for that row. A warning message will be printed with the serach value, API error message and status code.
}
\description{
This function is a wrapper for the \href{https://www.onemap.gov.sg/apidocs/search/}{Search API}. It allows for geocoding of data such as postal codes or address information. Users input a dataframe with a column to geocode (e.g. postal codes, address information).
It returns a tibble with additional columns of coordinate data. Optionally, it can also return the output as an \code{sf} object.
}
\examples{
# sample dataframe. the last record does not return any API results.
df <- data.frame(
  places = c("a", "b", "c", "d"),
  address = c("raffles place mrt", "suntec city", "nus", "100353")
)

# Returns the original df with additional columns
\dontrun{geocode_onemap(df, "address",
  return_geom=TRUE, address_details = TRUE, return_spatial=TRUE)
}
# If an error occurs for any of the rows, an empty row will be returned.
}
