% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par_ts.R
\name{par_ts}
\alias{par_ts}
\title{Set parameters for \code{\link{plot_ts}()}}
\usage{
par_ts(fromoptions = FALSE, p = NA, ...)
}
\arguments{
\item{fromoptions}{logical: Read the list of parameters set in \code{\link{options}("par_ts")$par_ts}, then the additional parameters set in \code{...} are replaced before the list is returned.}

\item{p}{List of the parameters, as returned by the function itself. If given, the additional parameters set in \code{...} are replaced before the list is returned.}

\item{...}{any of the following parameters can be set replacing the default values:

\code{xnm} "t": The name of the time

\code{legendspace} 10:
Horizontal space for the lengend in character spaces

\code{legendcex} 1: Scaling of the legend

\code{legendrangeshow} TRUE: Include the range for each variable in the legend

\code{ylimextend} c(lower,upper): Extend the ylim for each plot with a proportion, seperately for the lower and upper limit

\code{yaxisextend} c(lower,upper): Extend the yaxis for each plot with a proportion, seperately for the lower and upper limit

\code{mainsline} (numeric): with the \code{line} for the main in the plots.

\code{cex} (numeric): The cex to use for the \code{plot_ts} plots.

\code{plotfun}: The function used for plotting, as default \code{lines}.

\code{xaxisformat} (character): The format of the xaxis, see \code{\link{strptime}()}.

\code{colorramp} colorRampPalette: The colorramp used for setting multiple colors in each plot}
}
\value{
A list of the parameters above, which can be set globally (see examples) or passed to \code{\link{plot_ts}}.
}
\description{
Set parameters for \code{\link{plot_ts}()} globally
}
\details{
Often in a report some plot parameters must be set for all plots, which is done with \code{\link{par}()}.

The parameters which are general for \code{\link{plot_ts}()} can be set and saved in \code{\link{options}()},
and they will then be applied as default in all calls to plot_ts(). See the examples how to do this.

If any of these parameters are given to \code{\link{plot_ts}()}, then it will be used over the default.
}
\examples{

# Data for plots
D <- subset(Dbuilding, 1:192)

# See the parameters which can be set
p <- par_ts()
names(p)
p$xnm

# Using the default values
plot_ts(D, c("heatload","Ta"), kseq=1:24)

# Set the parameters directly
plot_ts(D, c("heatload","Ta"), kseq=1:24, legendcex=0.8, legendspace=8)

# Set parameters to be given in a list
p <- par_ts()
p$legendcex <- 0.8
p$legendspace <- 8

# Use those parameters
plot_ts(D, c("heatload","Ta"), kseq=1:24, p=p)

# Set globally (if not set specifed the default values will be used)
options(par_ts=p)

# Now the global parameters will be used
plot_ts(D, c("heatload","Ta"), kseq=1:24)

# Still providing a parameter directly it will used, e.g. change the plotting function
plot_ts(D, c("heatload","Ta"), kseq=1:24, plotfun=points)

# Control more precisely the plotting function
plot_ts(D, c("heatload","Ta"), kseq=1:24, plotfun=function(x, ...){ points(x, type="b", ...)})

# Another colorramp function
p$colorramp <- rainbow
options(par_ts=p)
plot_ts(D, c("heatload","Ta"), kseq=1:24)

}
