% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maker.R
\name{make_attribute}
\alias{make_attribute}
\alias{make_graph}
\alias{make_node}
\alias{make_tensor}
\alias{make_tensor_value_info}
\title{Make Different Types of Protos}
\usage{
make_attribute(key, value, doc_string = NULL)

make_graph(nodes, name, inputs, outputs, initializer = NULL, doc_string = NULL)

make_node(op_type, inputs, outputs, name = NULL, doc_string = NULL)

make_tensor(name, data_type, dims, vals, raw = FALSE)

make_tensor_value_info(name, elem_type, shape, doc_string = "")
}
\arguments{
\item{key}{The key}

\item{value}{The value}

\item{doc_string}{The doc_string}

\item{nodes}{The nodes}

\item{name}{The name}

\item{inputs}{The inputs}

\item{outputs}{The outputs}

\item{initializer}{The initializer}

\item{op_type}{The op type}

\item{data_type}{The data type}

\item{dims}{The dimensions}

\item{vals}{The values}

\item{raw}{If this is \verb{FALSE``, this function will choose the corresponding proto field to store the values based on }data_type\verb{. If raw is }TRUE`, use "raw_data" proto
field to store the values, and values should be of type bytes in this case.}

\item{elem_type}{The element type, e.g. \code{onnx$TensorProto$FLOAT}}

\item{shape}{The shape}
}
\description{
This includes AttributeProto, GraphProto, NodeProto, TensorProto,
TensorValueInfoProto, etc.
}
\examples{
\dontrun{

library(onnx)

# Define a node protobuf and check whether it's valid
node_def <- make_node("Relu", list("X"), list("Y"))
check(node_def)

# Define an attribute protobuf and check whether it's valid
attr_def <- make_attribute("this_is_an_int", 123L)
check(attr_def)

# Define a graph protobuf and check whether it's valid
graph_def <- make_graph(
    nodes = list(
      make_node("FC", list("X", "W1", "B1"), list("H1")),
      make_node("Relu", list("H1"), list("R1")),
      make_node("FC", list("R1", "W2", "B2"), list("Y"))
    ),
    name = "MLP",
    inputs = list(
      make_tensor_value_info('X' , onnx$TensorProto$FLOAT, list(1L)),
      make_tensor_value_info('W1', onnx$TensorProto$FLOAT, list(1L)),
      make_tensor_value_info('B1', onnx$TensorProto$FLOAT, list(1L)),
      make_tensor_value_info('W2', onnx$TensorProto$FLOAT, list(1L)),
      make_tensor_value_info('B2', onnx$TensorProto$FLOAT, list(1L))
    ),
    outputs = list(
      make_tensor_value_info('Y', onnx$TensorProto$FLOAT, list(1L))
    )
)
check(graph_def)

}

}
