% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Oest.R
\name{Oest}
\alias{Oest}
\title{Oest}
\usage{
Oest(x, ...)
}
\arguments{
\item{x}{ppp}

\item{...}{Arguments passed to \code{spatstat.explore::pcf.ppp()}}
}
\value{
fv.object
}
\description{
O-ring function
}
\details{
Estimates the O-ring function proposed by Wiegand and Moloney (2004). The
O-ring statistic is defined as:

\deqn{O(r) = \lambda * g(r)}

Generally speaking, O(r) scales the pair correlation g(r) function with help
of the intensity \eqn{\lambda}. One advantage of the O-ring statistic is that
it can be interpreted as a neighborhood density because it is a probability density
function (Wiegand & Moloney 2004, 2014).

Returns an 'Function value object' of the \code{spatstat} package.
}
\examples{
input_pattern <- spatstat.random::runifpoint(n = 100)
Oest(input_pattern)

}
\references{
Wiegand, T., Moloney, K.A., 2004. Rings, circles, and null models for point pattern
analysis in ecology. Oikos 104, 209–229. <https://doi.org/10.1111/j.0030-1299.2004.12497.x>

Wiegand, T., Moloney, K.A., 2014. Handbook of spatial point-pattern analysis in
ecology. Chapman and Hall/CRC Press, Boca Raton, USA. <isbn:978-1-4200-8254-8>
}
\seealso{
\code{\link[spatstat.explore]{density.ppp}} \cr
\code{\link[spatstat.explore]{pcf}}
}
