% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ontology_operations_main.R
\docType{data}
\name{HAO}
\alias{HAO}
\title{Hymenoptera Anatomy Ontology (HAO)}
\format{List containing various ontological relationships and terms.}
\usage{
HAO
}
\description{
Anatomy ontology of Hymenoptera. This ontology was imported into R using get_OBO() function from ontologyIndex package (see the examples).
}
\examples{
data(HAO)
# you can also parse the original .obo file
get_OBO(system.file("data_onto", "HAO.obo", package = "ontoFAST"),
extract_tags="everything", propagate_relationships = c("BFO:0000050", "is_a"))
}
\references{
Yoder MJ, Mikó I, Seltmann KC, Bertone MA, Deans AR. 2010. A Gross Anatomy Ontology for Hymenoptera. PLoS ONE 5 (12): e15991.
(\href{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0015991}{Read})

\href{http://portal.hymao.org/projects/32/public/ontology/}{Hymenoptera Anatomy Ontology Portal}
}
\keyword{datasets}
