% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramo_functions.R
\name{discr_Simmap_all}
\alias{discr_Simmap_all}
\title{Reading unsummarized simmap for a list of trees}
\usage{
discr_Simmap_all(tree, res)
}
\arguments{
\item{tree}{multiSimmap or multiPhylo object.}

\item{res}{integer. A resolution value for the discretization of tree edges.}
}
\value{
A multiSimmap or multiPhylo object.
}
\description{
Discretizes tree edges of a list of trees.
}
\examples{
data("hym_stm")
tree_list <- hym_stm[[1]]
stm_discr_list <- discr_Simmap_all(tree_list, res = 100)
# Check some arbitrary branch of some arbitrary tree.
tree_list[[1]]$maps[[8]]
stm_discr_list[[1]]$maps[[8]]
sum(tree_list[[1]]$maps[[8]])
sum(stm_discr_list[[1]]$maps[[8]])

}
\author{
Sergei Tarasov
}
