% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.install_local_package}
\alias{dsadmin.install_local_package}
\title{Install a DataSHIELD package from a local archive file}
\usage{
dsadmin.install_local_package(opal, path, profile = NULL)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{path}{Path to the package archive, ending with .}

\item{profile}{The DataSHIELD profile name to which operation applies. See also \link{dsadmin.profiles}.}
}
\description{
Install a package from a package archive file, resulting from the build of a server-side DataSHIELD package.
This will upload the archive file and run its installation in the R server.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# install a pre-built local archive file
dsadmin.install_local_package(o, '~/dsExposome_1.0.0.tar.gz')
# or build archive file from local package source (in current working folder)
dsadmin.install_local_package(o, devtools::build())
opal.logout(o)
}
}
\seealso{
Other DataSHIELD functions: 
\code{\link{dsadmin.get_method}()},
\code{\link{dsadmin.get_methods}()},
\code{\link{dsadmin.get_options}()},
\code{\link{dsadmin.install_github_package}()},
\code{\link{dsadmin.install_package}()},
\code{\link{dsadmin.installed_package}()},
\code{\link{dsadmin.package_description}()},
\code{\link{dsadmin.package_descriptions}()},
\code{\link{dsadmin.publish_package}()},
\code{\link{dsadmin.remove_package}()},
\code{\link{dsadmin.rm_method}()},
\code{\link{dsadmin.rm_methods}()},
\code{\link{dsadmin.rm_option}()},
\code{\link{dsadmin.rm_options}()},
\code{\link{dsadmin.rm_package_methods}()},
\code{\link{dsadmin.set_method}()},
\code{\link{dsadmin.set_option}()},
\code{\link{dsadmin.set_package_methods}()},
\code{\link{dsadmin.unpublish_package}()}
}
\concept{DataSHIELD functions}
