% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openEBGM-package.R
\docType{package}
\name{openEBGM-package}
\alias{openEBGM}
\alias{openEBGM-package}
\title{openEBGM: EBGM Disproportionality Scores for Adverse Event Data Mining}
\description{
An implementation of DuMouchel's (1999) \doi{10.1080/00031305.1999.10474456} Bayesian data mining method for the market basket problem. Calculates Empirical Bayes Geometric Mean (EBGM) and posterior quantile scores using the Gamma-Poisson Shrinker (GPS) model to find unusually large cell counts in large, sparse contingency tables. Can be used to find unusually high reporting rates of adverse events associated with products. In general, can be used to mine any database where the co-occurrence of two variables or items is of interest. Also calculates relative and proportional reporting ratios. Builds on the work of the 'PhViD' package, from which much of the code is derived. Some of the added features include stratification to adjust for confounding variables and data squashing to improve computational efficiency. Includes an implementation of the EM algorithm for hyperparameter estimation loosely derived from the 'mederrRank' package.
}
\section{Data preparation & squashing functions}{

The data preparation function, \code{\link{processRaw}}, converts raw data
  into actual and expected counts for product/event pairs.
  \code{\link{processRaw}} also adds the relative reporting ratio (RR) and
  proportional reporting ratio (PRR). The data squashing function,
  \code{\link{squashData}}, implements the simple version of data squashing
  described in DuMouchel et al. (2001). Data squashing can be used to reduce
  computational burden.
}

\section{Negative log-likelihood functions}{

The negative log-likelihood functions (\code{\link{negLL}},
  \code{\link{negLLsquash}}, \code{\link{negLLzero}}, and
  \code{\link{negLLzeroSquash}}) provide the means of calculating the
  negative log-likelihoods as mentioned in the DuMouchel papers. DuMouchel
  uses the likelihood function, based on the marginal distributions of the
  counts, to estimate the hyperparameters of the prior distribution.
}

\section{Hyperparameter estimation functions}{

The hyperparameter estimation functions (\code{\link{exploreHypers}} and
  \code{\link{autoHyper}}) use gradient-based approaches to estimate the
  hyperparameters, \eqn{\theta}, of the prior distribution (gamma mixture)
  using the negative log-likelihood functions from the marginal distributions
  of the counts (negative binomial). \eqn{\theta} is a vector containing five
  parameters (\eqn{\alpha_1}, \eqn{\beta_1}, \eqn{\alpha_2}, \eqn{\beta_2},
  and \eqn{P}). \code{\link{hyperEM}} estimates \eqn{\theta} using a version
  of the EM algorithm.
}

\section{Posterior distribution functions}{

The posterior distribution functions calculate the mixture fraction
  (\code{\link{Qn}}), geometric mean (\code{\link{ebgm}}), and quantiles
  (\code{\link{quantBisect}}) of the posterior distribution. Alternatively,
  \code{\link{ebScores}} can be used to create an object of class openEBGM
  that contains the EBGM and quantiles scores. Appropriate methods exist for
  the generic functions \code{\link[base]{print}},
  \code{\link[base]{summary}}, and \code{\link[graphics]{plot}} for openEBGM
  objects.
}

\references{
Ahmed I, Poncet A (2016). \pkg{PhViD}: an R package for
  PharmacoVigilance signal Detection. \emph{R package version 1.0.8}.

Venturini S, Myers J (2015). \pkg{mederrRank}: Bayesian Methods
  for Identifying the Most Harmful Medication Errors. \emph{R package version
  0.0.8}.

DuMouchel W (1999). "Bayesian Data Mining in Large Frequency
  Tables, With an Application to the FDA Spontaneous Reporting System."
  \emph{The American Statistician}, 53(3), 177-190.

DuMouchel W, Pregibon D (2001). "Empirical Bayes Screening for
  Multi-item Associations." In \emph{Proceedings of the Seventh ACM SIGKDD
  International Conference on Knowledge Discovery and Data Mining}, KDD '01,
  pp. 67-76. ACM, New York, NY, USA. ISBN 1-58113-391-X.

Evans SJW, Waller P, Davis S (2001). "Use of Proportional
  Reporting Ratios (PRRs) for Signal Generation from Spontaneous Adverse Drug
  Reaction Reports." \emph{Pharmacoepidemiology and Drug Safety}, 10(6),
  483-486.

FDA (2017). "CFSAN Adverse Event Reporting System (CAERS)."
  URL \url{https://www.fda.gov/food/compliance-enforcement-food/cfsan-adverse-event-reporting-system-caers}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://journal.r-project.org/archive/2017/RJ-2017-063/index.html}
}

}
\author{
\strong{Maintainer}: John Ihrie \email{John.Ihrie@fda.hhs.gov}

Authors:
\itemize{
  \item Travis Canida \email{Travis.Canida@fda.hhs.gov}
}

Other contributors:
\itemize{
  \item Ismaïl Ahmed (author of 'PhViD' package (derived code)) [contributor]
  \item Antoine Poncet (author of 'PhViD') [contributor]
  \item Sergio Venturini (author of 'mederrRank' package (derived code)) [contributor]
  \item Jessica Myers (author of 'mederrRank') [contributor]
}

}
\keyword{internal}
