% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_classFunctions.R
\name{summary.openEBGM}
\alias{summary.openEBGM}
\title{Summarize an openEBGM object}
\usage{
\method{summary}{openEBGM}(object, plot.out = TRUE, log.trans = FALSE, ...)
}
\arguments{
\item{object}{An openEBGM object constructed by \code{\link{ebScores}}}

\item{plot.out}{A logical value indicating whether or not a histogram of the
EBGM scores should be displayed}

\item{log.trans}{A logical value indicating whether or not the data should be
log-transformed.}

\item{...}{Additional arguments affecting the summary produced}
}
\description{
Summarize an openEBGM object
}
\details{
This function provides a brief summary of the results of the
         calculations performed in the \code{\link{ebScores}} function. In
         particular, it provides the numerical summary of the EBGM and
         QUANT_* vectors.

Additionally, calling \code{\link[base]{summary}} on an openEBGM
         object will produce a histogram of the EBGM scores. By setting the
         log.trans parameter to TRUE, one can convert the EBGM score to
         EBlog2, which is a Bayesian version of the information criterion
         (DuMouchel).
}
\examples{
data.table::setDTthreads(2)  #only needed for CRAN checks
theta_init <- data.frame(
  alpha1 = c(0.5, 1),
  beta1  = c(0.5, 1),
  alpha2 = c(2,   3),
  beta2  = c(2,   3),
  p      = c(0.1, 0.2)
)
data(caers)
proc <- processRaw(caers)
squashed <- squashData(proc, bin_size = 300, keep_pts = 10)
squashed <- squashData(squashed, count = 2, bin_size = 13, keep_pts = 10)
suppressWarnings(
  hypers <- autoHyper(data = squashed, theta_init = theta_init)
)
ebout <- ebScores(processed = proc, hyper_estimate = hypers, quantiles = 5)
summary(ebout)
\dontrun{summary(ebout, plot.out = FALSE)}
\dontrun{summary(ebout, log.trans = TRUE)}

}
\references{
DuMouchel W (1999). "Bayesian Data Mining in Large Frequency
  Tables, With an Application to the FDA Spontaneous Reporting System."
  \emph{The American Statistician}, 53(3), 177-190.
}
\keyword{openEBGM}
