% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traj_trajMap.R
\name{trajMapStatic}
\alias{trajMapStatic}
\title{Trajectory line plots in \code{ggplot2}}
\usage{
trajMapStatic(
  data,
  colour = "height",
  type = NULL,
  group = NULL,
  size = NULL,
  linewidth = size,
  longitude = "lon",
  latitude = "lat",
  npoints = 12,
  xlim = NULL,
  ylim = NULL,
  crs = sf::st_crs(3812),
  origin = TRUE,
  map = TRUE,
  map.fill = "grey85",
  map.colour = "grey75",
  map.alpha = 0.8,
  map.lwd = 0.5,
  map.lty = 1,
  facet = NULL,
  ...
)
}
\arguments{
\item{data}{\emph{A data frame containing a HYSPLIT trajectory, perhaps accessed
with \code{\link[openair:importTraj]{openair::importTraj()}}.}

\strong{required}

A data frame containing HYSPLIT model outputs. If this data were not
obtained using \code{\link[openair:importTraj]{openair::importTraj()}}.}

\item{colour}{\emph{Data column to map to the colour of the trajectories.}

\emph{default:} \code{NULL}

This column may be numeric, character, factor or date(time). This will
commonly be a pollutant concentration which has been joined (e.g., by
\code{\link[dplyr:mutate-joins]{dplyr::left_join()}}) to the trajectory data by "date". The scale can be
edited after the fact using \code{\link[ggplot2:scale_colour_continuous]{ggplot2::scale_color_continuous()}} or similar.}

\item{type}{\emph{A method to condition the \code{data} for separate plotting.}

\emph{default:} \code{NULL}

Used for splitting the trajectories into different groups which will appear
as different panels. Passed to \code{\link[openair:cutData]{openair::cutData()}}.}

\item{group}{\emph{Column to use to distinguish different trajectory paths.}

\emph{default:} \code{NULL}

By default, trajectory paths are distinguished using the arrival date.
\code{group} allows for additional columns to be used (e.g., \code{"receptor"} if
multiple receptors are being plotted).}

\item{size, linewidth}{\emph{Data column to map to the size/width of the trajectory
marker/paths, or absolute size value.}

\emph{default:} \code{NULL}

Similar to the \code{colour} argument, this defines a column to map to the size
of the circular markers or the width of the paths. These scales can be
edited after the fact using \code{\link[ggplot2:scale_size]{ggplot2::scale_size_continuous()}},
\code{\link[ggplot2:scale_linewidth]{ggplot2::scale_linewidth_continuous()}}, or similar. If numeric, the value
will be directly provided to \code{ggplot2::geom_point(size = )} or
\code{ggplot2::geom_path(linewidth = )}.}

\item{latitude, longitude}{\emph{The decimal latitude/longitude.}

\emph{default:} \code{"lat"} / \code{"lon"}

Column names representing the decimal latitude and longitude.}

\item{npoints}{\emph{Interval at which points are placed along the trajectory
paths.}

\emph{default:} \code{12}

A dot is placed every \code{npoints} along each full trajectory. For hourly back
trajectories points are plotted every \code{npoints} hours. This helps to
understand where the air masses were at particular times and get a feel for
the speed of the air (points closer together correspond to slower moving
air masses). Defaults to \code{12}.}

\item{xlim, ylim}{\emph{The x- and y-limits of the plot.}

\emph{default:} \code{NULL}

A numeric vector of length two defining the x-/y-limits of the map, passed
to \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}}. If \code{NULL}, limits will be estimated based on the
lat/lon ranges of the input data.}

\item{crs}{\emph{The coordinate reference system (CRS) into which all data should
be projected before plotting.}

\emph{default:} \code{sf::st_crs(3812)}

This argument defaults to the Lambert projection, but can take any
coordinate reference system to pass to the \code{crs} argument of
\code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}}. Alternatively, \code{crs} can be set to \code{NULL}, which
will typically render the map quicker but may cause countries far from the
equator or large areas to appear distorted.}

\item{origin}{\emph{Draw the receptor point as a circle?}

\emph{default:} \code{TRUE}

When \code{TRUE}, the receptor point(s) are marked with black circles.}

\item{map}{\emph{Draw a base map?}

\emph{default:} \code{TRUE}

Draws the geometries of countries under the trajectory paths.}

\item{map.fill}{\emph{Colour to use to fill the polygons of the base map.}

\emph{default:} \code{"grey85"}

See \code{colors()} for colour options. Alternatively, a hexadecimal color code
can be provided.}

\item{map.colour}{\emph{Colour to use for the polygon borders of the base map.}

\emph{default:} \code{"grey75"}

See \code{colors()} for colour options. Alternatively, a hexadecimal color code
can be provided.}

\item{map.alpha}{\emph{Transparency of the base map polygons.}

\emph{default:} \code{0.8}

Must be between \code{0} (fully transparent) and \code{1} (fully opaque).}

\item{map.lwd}{\emph{Line width of the base map polygon borders.}

\emph{default:} \code{0.5}

Any numeric value.}

\item{map.lty}{\emph{Line type of the base map polygon borders.}

\emph{default:} \code{1}

See \code{\link[ggplot2:scale_linetype]{ggplot2::scale_linetype()}} for common examples. The default, \code{1},
draws solid lines.}

\item{facet}{Deprecated. Please use \code{type}.}

\item{...}{
  Arguments passed on to \code{\link[openair:cutData]{openair::cutData}}
  \describe{
    \item{\code{hemisphere}}{Can be \code{"northern"} or \code{"southern"}, used to
split data into seasons.}
    \item{\code{n.levels}}{Number of quantiles to split numeric data into.}
    \item{\code{start.day}}{What day of the week should the \code{type = "weekday"}
start on?  The user can change the start day by supplying an integer
between 0 and 6. Sunday = 0, Monday = 1, \ldots For example to start the
weekday plots on a Saturday, choose \code{start.day = 6}.}
    \item{\code{is.axis}}{A logical (\code{TRUE}/\code{FALSE}), used to request
shortened cut labels for axes.}
    \item{\code{local.tz}}{Used for identifying whether a date has daylight savings time
(DST) applied or not. Examples include \code{local.tz = "Europe/London"},
\code{local.tz = "America/New_York"} i.e. time zones that assume DST.
\url{https://en.wikipedia.org/wiki/List_of_zoneinfo_time_zones} shows time
zones that should be valid for most systems. It is important that the
original data are in GMT (UTC) or a fixed offset from GMT. See
\code{import} and the openair manual for information on how to import data
and ensure no DST is applied.}
  }}
}
\value{
a \code{ggplot2} plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function plots back trajectories using \code{ggplot2}. The function
requires that data are imported using \code{\link[openair:importTraj]{openair::importTraj()}}. It is a
\code{ggplot2} implementation of \code{\link[openair:trajPlot]{openair::trajPlot()}} with many of the same
arguments, which should be more flexible for post-hoc changes.
}
\examples{
\dontrun{
# colour by height
trajMapStatic(traj_data) +
  ggplot2::scale_color_gradientn(colors = openair::openColours())

# colour by PM10, log transform scale
trajMapStatic(traj_data, colour = "pm10") +
  ggplot2::scale_color_viridis_c(trans = "log10") +
  ggplot2::labs(color = openair::quickText("PM10"))

# color by PM2.5, lat/lon projection
trajMapStatic(traj_data, colour = "pm2.5", crs = sf::st_crs(4326)) +
  ggplot2::scale_color_viridis_c(option = "turbo") +
  ggplot2::labs(color = openair::quickText("PM2.5"))
}
}
\seealso{
\code{\link[openair:trajPlot]{openair::trajPlot()}}

\code{\link[=trajMap]{trajMap()}} for the interactive \code{leaflet} equivalent of
\code{\link[=trajMapStatic]{trajMapStatic()}}

Other static trajectory maps: 
\code{\link{trajLevelMapStatic}()}
}
\concept{static trajectory maps}
