% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateOpenBankingClient.R
\name{CreateOpenBankingClient}
\alias{CreateOpenBankingClient}
\title{CreateOpenBankingClient}
\usage{
CreateOpenBankingClient(
  bankDetails = "default",
  version = "latest",
  timeOutSeconds = 15
)
}
\arguments{
\item{bankDetails}{optional. Bank details list to use. When set to "default", the
bank details will be taken from the below URL:
https://github.com/OpenBankingUK/opendata-api-spec-compiled/blob/master/participant_store.json

Otherwise, the user can provide a custom list of bank details.}

\item{version}{optional. Which version of the API to use. Defaults to "latest".
When set to "latest", the version used will be the latest available for the selected bank and instrument. 
The latest available version information will be derived from the bank details table above.
Alternatively, the user can supply a manually set version such as "v2.3"}

\item{timeOutSeconds}{optional. Number of seconds before a request times out. Defaults to 15 seconds}
}
\value{
Object of type OpenBankingClient with methods for querying the API
}
\description{
Creates a new Open Banking (Open Data) API client with convenient queries
}
\section{Available client fields}{

\itemize{
  \item \strong{BankDetails}: The default table of bank details used to query the API.
}
}

\section{Available client queries}{

\itemize{
  \item \strong{GetAvailableBanks}: Get a list of banks that report the API.
  \item \strong{GetAvailableInstruments}: Get a list of instruments reported via the API.
  \item \strong{GetRawData}: Get raw data using the API for a given bank and instrument.
}
}

\examples{
\donttest{
library(openbankeR)

openBankingClient <- openbankeR::CreateOpenBankingClient()

bankDetails <- openBankingClient$BankDetails
   
availableBanks <- openBankingClient$GetAvailableBanks()
availableInstruments <- openBankingClient$GetAvailableInstruments()

bankName <- "HSBC Group"
instrument <- "branches"

rawData <- openBankingClient$GetRawData(
  bankName = bankName,
  instrument = instrument
)
}

}
