% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-friday.R
\docType{data}
\name{friday}
\alias{friday}
\title{Friday the 13th}
\format{
A data frame with 61 observations and 6 variables.
\describe{
\item{type}{Type of observation, \code{traffic}, \code{shopping}, or \code{accident}.}
\item{date}{Year and month of observation.}
\item{sixth}{Counts on the 6th of the month.}
\item{thirteenth}{Counts on the 13th of the month.}
\item{diff}{Difference between the sixth and the thirteenth.}
\item{location}{Location where data is collected.}
}
}
\source{
Scanlon, T.J., Luben, R.N., Scanlon, F.L., Singleton, N. (1993), "Is
Friday the 13th Bad For Your Health?," BMJ, 307, 1584-1586.
\url{https://dasl.datadescription.com/datafile/friday-the-13th-traffic} and
\url{https://dasl.datadescription.com/datafile/friday-the-13th-accidents}.
}
\usage{
friday
}
\description{
This dataset addresses issues of how superstitions regarding Friday the
13th affect human behavior, and whether Friday the 13th is an unlucky day.
Scanlon, et al. collected data on traffic and shopping patterns and accident
frequency for Fridays the 6th and 13th between October of 1989 and November
of 1992.
}
\details{
There are three types of observations: traffic, shopping, and accident. For
traffic, the researchers obtained information from the British Department of
Transport regarding the traffic flows between junctions 7 to 8 and junctions
9 to 10 of the M25 motorway. For shopping, they collected the numbers of
shoppers in nine different supermarkets in southeast England. For accidents,
they collected numbers of emergency admissions to hospitals due to transport
accidents.
}
\examples{

library(dplyr)
library(ggplot2)

friday |>
  filter(type == "traffic") |>
  ggplot(aes(x = sixth)) +
  geom_histogram(binwidth = 2000) +
  xlim(110000, 140000)

friday |>
  filter(type == "traffic") |>
  ggplot(aes(x = thirteenth)) +
  geom_histogram(binwidth = 2000) +
  xlim(110000, 140000)
}
\keyword{datasets}
