% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-ModelRunResults.R
\name{get_model_run}
\alias{get_model_run}
\alias{get_run}
\alias{get_model_runs_list}
\alias{get_model_runs}
\alias{get_runs}
\alias{get_model_run_status}
\alias{get_run_status}
\alias{get_model_run_list_status}
\alias{get_model_run_status_first}
\alias{get_model_run_status_last}
\alias{get_model_run_status_compl}
\title{Model Run Results Metadata}
\usage{
get_model_run(model, run)

get_run(model, run)

get_model_runs_list(model)

get_model_runs(model)

get_runs(model)

get_model_run_status(model, run)

get_run_status(model, run)

get_model_run_list_status(model, run)

get_model_run_status_first(model)

get_model_run_status_last(model)

get_model_run_status_compl(model)
}
\arguments{
\item{model}{Model digest or model name.}

\item{run}{Model run digest, run stamp or run name, modeling task run
stamp or task run name.}
}
\value{
A \code{list}, \code{tibble}, or nothing (invisibly).
}
\description{
Functions to retrieve model run metadata and delete model runs. More
information about these API endpoints can be found at \href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#get-model-run-results-metadata}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
get_model_run("RiskPaths", "53300e8b56eabdf5e5fb112059e8c137")
get_run("RiskPaths", "53300e8b56eabdf5e5fb112059e8c137")
get_model_runs_list("RiskPaths")
get_model_runs("RiskPaths")
}


}
