% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-UpdateModelProfile.R
\name{touch_model_profile}
\alias{touch_model_profile}
\alias{delete_model_profile}
\alias{set_model_profile_opt}
\alias{delete_model_profile_opt}
\title{Update Model Profile}
\usage{
touch_model_profile(model, data)

delete_model_profile(model, profile)

set_model_profile_opt(model, profile, key, value)

delete_model_profile_opt(model, profile, key)
}
\arguments{
\item{model}{Model digest or model name.}

\item{data}{Data used for the body of the request.}

\item{profile}{Profile name.}

\item{key}{Option key.}

\item{value}{Option value.}
}
\value{
A \code{list} from a JSON response object or nothing (invisibly).
}
\description{
Functions for creating, modifying, and deleting profiles and profile options.
More information about these API endpoints can be found at
\href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#update-model-profile-set-of-key-value-options}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
touch_model_profile(
  "RiskPaths",
  list(Name = "profile1", Opts = list(Parameter.StartingSeed = "192"))
)
delete_model_profile("RiskPaths", "profile1")
}

}
