% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directions.R
\name{ors_directions}
\alias{ors_directions}
\title{Openrouteservice Directions}
\usage{
ors_directions(
  coordinates,
  profile = ors_profile(),
  format = c("geojson", "json", "gpx"),
  ...,
  api_key = ors_api_key(),
  output = c("parsed", "text", "sf")
)
}
\arguments{
\item{coordinates}{List of \verb{longitude, latitude} coordinate pairs visited in order, alternatively a two column \code{matrix} or \code{data.frame}.}

\item{profile}{Route profile, defaults to \code{"driving-car"}.}

\item{format}{Response format, defaults to \code{"geojson"}}

\item{...}{Optional parameters as described \href{https://openrouteservice.org/dev/#/api-docs/v2/directions/{profile}/post}{here}}

\item{api_key}{Character scalar containing openrouteservice API key}

\item{output}{Output format. By default the response is being parsed to a list-based R object}
}
\value{
Route between two or more locations in the selected \code{format} structured according to \code{output}:

\itemize{
\item for \code{"text"}, a character vector of length 1 re-encoded to UTF-8.
}

\itemize{
\item for \code{"parsed"}, a parsed R object.
}

\itemize{
\item for \code{"sf"}, a simple features \code{\link[sf]{sf}} object.
}
}
\description{
Get directions for different modes of transport.
}
\examples{
# These examples might require interaction to query the local keyring, or
# might fail due to network issues, so they are not run by default
\dontrun{
coordinates <- list(c(8.34234, 48.23424), c(8.34423, 48.26424))

# simple call
try( ors_directions(coordinates, preference="fastest") )

# customized options
try( ors_directions(coordinates, profile="cycling-mountain", elevation=TRUE) )

# list of locations as `data.frame` output as simple features `sf` object
locations <- data.frame(lng = c(8.34234, 8.327807, 8.34423),
                        lat = c(48.23424, 48.239368, 48.26424))
try( ors_directions(locations, output = "sf") )
}
}
\author{
Andrzej Oleś \href{mailto:andrzej.oles@gmail.com}{andrzej.oles@gmail.com}
}
