% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oscai.R
\name{oscai}
\alias{oscai}
\title{Score with an AI
A basic function to score the creativity with an AI.
See \href{https://openscoring.du.edu/scoringllm}{the OpenScoring site}
for more information. Requires an internet connection.}
\usage{
oscai(
  df,
  item,
  answer,
  model = c("1.6", "1-4o", "davinci3", "chatgpt2", "1.5", "chatgpt", "babbage2",
    "davinci2"),
  language = "English",
  scores_col = ".originality",
  quiet = FALSE
)
}
\arguments{
\item{df}{A data frame.}

\item{item}{The column name of the items or other kind of prompt.}

\item{answer}{The column name of the responses. Commas will be replaced with spaces for scoring.}

\item{model}{The model to use. Should be one of "1.6", "1-4o", "davinci3", "chatgpt2". Deprecated models are kept for compatibility.}

\item{language}{The language of the input. Only works for the 1.5 model upwards. Should be one of "Arabic", "Chinese", "Dutch", "English", "French", "German", "Hebrew", "Italian", "Polish", "Russian", "Spanish".}

\item{scores_col}{The column name to store the scores in. Defaults to ".originality".}

\item{quiet}{Whether to print the citation reminder.}
}
\value{
The input data frame with the scores added.
}
\description{
Score with an AI
A basic function to score the creativity with an AI.
See \href{https://openscoring.du.edu/scoringllm}{the OpenScoring site}
for more information. Requires an internet connection.
}
\details{
Available models:
\itemize{
\item ocsai-1.6: Update to the multi-lingual, multi-task 1.5 model, trained on GPT 4o instead of 3.5.
\item ocsai1-4o: GPT-4o-based model, trained with more data and supporting multiple tasks. Last update to the Ocsai 1 models (i.e. the original ones).
\item ocsai-chatgpt2: GPT-3.5-size chat-based model, trained with more data and supporting multiple tasks. Scoring is slower, with slightly better performance than ocsai-davinci.
\item ocsai-davinci3: GPT-3 Davinci-size model. Trained with the method from Organisciak et al. 2023, but with the additional tasks (uses, consequences, instances, complete the sentence) from Acar et al 2023, and trained with more data.
\item ocsai-1.5: Beta version of new multi-lingual, multi-task model, trained on GPT 3.5.
\item ocsai-chatgpt: GPT-3.5-size chat-based model, trained with same format and data as original models. Scoring is slower, with slightly better performance than ocsai-davinci2. For more tasks and trained on more data, use davinci-ocsai2
\item ocsai-babbage2: GPT-3 Babbage-size model from the paper, retrained with new model API. Deprecated, mainly because other models work better.
\item ocsai-davinci2: GPT-3 Davinci-size model from the paper, retrained with a new model API.
}
}
\examples{
df <- data.frame(
  stimulus = c("brick", "hammer", "sponge"),
  response = c("butter for trolls", "make Thor jealous", "make it play in a kids show")
)

df <- oscai(df, stimulus, response, model = "davinci3")

# The 1.5 model and upwards works for multiple languages
df_polish <- data.frame(
  stimulus = c("cegła", "młotek", "gąbka"),
  response = c("masło dla trolli", "wywoływanie zazdrości u Thora", "postać w programie dla dzieci")
)

df_polish <- oscai(df_polish, stimulus, response, model = "1.5", language = "Polish")

}
