% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cost_parameters}
\alias{cost_parameters}
\title{Cost parameters for species used in examples}
\format{
A \code{\link[tibble]{tibble}} of  variables and 16 records
\describe{
  \item{spp}{Species common name}
  \item{source}{The source of the data. WDNR is from Wisconsin Dep't of
    Natural Resources Hatchery cost data. AFS is the
    American Fisheries Society Special Publication 35 on Fishkill Replacement
    costs
  }
  \item{cost_fun_type}{Either "exp" for exponential -- corresponds to the
    \code{\link{total_cost}} cost function, or "linear" -- corresponds to the
    \code{\link{linear_total_cost}} cost function.
  }
  \item{cost_fun}{The cost function -- either
    \code{\link{total_cost}} or \code{\link{linear_total_cost}}
  }
  \item{cost_fun_params}{A list-col of the parameters necessary for
    the respective cost function found in \code{cost_fun}
  }
}
}
\usage{
cost_parameters
}
\description{
This data.frame contains the cost parameters used in
\code{\link{spp_examples}}. These parameters correspond with the
\code{\link{total_cost}} and \code{\link{linear_total_cost}} functions.
}
\keyword{datasets}
