% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_opus.R
\name{read_opus}
\alias{read_opus}
\title{Read OPUS binary files from Bruker spectrometers}
\usage{
read_opus(dsn, data_only = FALSE, parallel = FALSE, progress_bar = FALSE)
}
\arguments{
\item{dsn}{data source name. Can be a path to a specific file or a path to a
directory. The listing of the files in a directory is recursive.}

\item{data_only}{read data and parameters with \code{FALSE} per default, or only
read data \code{NULL}, which only returns the parsed data.}

\item{parallel}{read files in parallel via \code{"mirai"} (non-blocking parallel
map). Default is \code{FALSE}. See section "Details" for more information.}

\item{progress_bar}{print a progress bar. Default is \code{FALSE}.}
}
\value{
List with OPUS spectra collection of class \code{list_opusreader2}. The
individual elements are individual sample measurement data extracted from the
corresponding OPUS binary files, as parsed from the encoded data blocks.

Each element in \code{list_opusreader2} contains metadata and measurement data
equivalent to their names displayed in the Bruker OPUS viewer software.
However, we used snake_case and standardized the naming for better output
handling.

Each parsed block element is a sublist that contains

\strong{1.} the binary read instructions decoded/derived from the header
(\verb{$block_type}, \verb{$channel_type}, \verb{$text_type} and \verb{$additional_type},
\verb{$offset} (bytes), \verb{$next_offset} (bytes), \verb{$chunk_size} (bytes)).

\strong{2.} if parameter block, nested list of specific parameters under
\verb{$parameters}, which has elements named according to capitalized
Bruker-internal "three-letter-string" definitions (e.g., "DPF := Data Point
Format").

Possible first-level block names and information provided include:
\itemize{
\item \strong{\code{refl_no_atm_comp_data_param}} : class \code{parameter} (viewer: "Data
Parameters Refl". Parameter list with metadata for \code{refl} data block
(\code{refl}).
\item \strong{\code{refl_no_atm_comp}}: class \code{data} (spectrum; viewer: "Refl").
Unprocessed (raw; i.e, not atmospherically compensated) reflectance spectra
(\verb{:= sc_sample / sc_ref}). Note that this element is the untreated spectra
before an eventual "atmospheric compensation" routine is applied.
\item \strong{\code{refl_data_param}} : class \code{parameter} (viewer: "Data Parameters Refl").
Parameter list with metadata for \code{refl} data block (metadata of
reflectance spectrum; see \code{refl} output). Note that this element only
results if "atmospheric compensation" was activated in the OPUS
measurement settings.
\item \strong{\code{refl}}: class \code{data} (spectrum; viewer: "Refl"). Atmospherically
compensated reflectance spectra (\verb{:= sc_sample_corr / sc_ref_corr}). This
result spectrum only exists if either correction of CO2 and/or water vapour
bands is set in OPUS setting (proprietary algorithm; could possibly be
reverse engineered). If \code{refl} exists, it has always a corresponding
untreated \code{refl_no_atm_comp} spectrum  (the latter present in file but not
shown in the OPUS viewer, where only (final) \code{ab} is displayed)
\item \strong{\code{quant_report_refl}}: class \code{parameter} (viewer: "Quant Report Refl").
Quantification report for tools of multivariate calibration on \code{refl} data
(i.e., PLS regression) offered in the QUANT2 OPUS package. Nested list with
Bruker-internal "three-letter-string" definitions. "TIT" is the title of a
nested quantification table, \code{"E<digit>[2]"} stands probably for entry,
\code{"F<digit>[2]"} for field, and \code{"Z<digit>[2]"} we do not yet know what it
maps to. There seems more information needed, which we can get by expanding
the header parsing algorithm.
\item \strong{\code{ab_no_atm_comp_data_param}} : class \code{parameter} (viewer: "Data
Parameters AB"). Parameter list with metadata for \code{ab} data block
(spectrum; see \code{ab} output).
\item \strong{\code{ab_no_atm_comp}}: class \code{data} (spectrum; viewer: "Refl"). Unprocessed
(raw; i.e, not atmospherically compensated) reflectance spectra (\verb{:= sc_sample/ sc_ref}).
\item \strong{\code{ab_data_param}} : class \code{parameter} (viewer: "Data Parameters Refl").
Parameter list with metadata for \code{ab} data block (spectrum; see \code{ab}).
Note that this element only results if "atmospheric compensation" was
activated in the OPUS measurement settings.
\item \strong{\code{ab}}: class \code{data} (spectrum; viewer: "AB"). Atmospherically
compensated (apparent) absorbance spectra (\verb{:= log10(1 / (sc_sample_corr / sc_ref_corr)}). Only exists if either correction of CO2 and/or water vapour
bands is set in OPUS setting (proprietary algorithm; could possibly be
reverse engineered). If \code{AB} exists, it has always a corresponding
untreated \code{ab_no_atm_comp} spectrum (the latter present in file but not
shown in the OPUS viewer, where only final \code{ab} is displayed).
\item \strong{\code{quant_report_ab}}: class \code{parameter} (viewer: "Quant Report AB").
Quantification report for tools of multivariate calibration on \code{ab} data
(i.e., PLS regression) offered in the QUANT2 OPUS package. Nested list with
Bruker-internal "three-letter-string" definitions. "TIT" is the title of a
nested quantification table, \code{"E<digit>[2]"} stands probably for entry,
\code{"F<digit>[2]"} for field, and \code{"Z<digit>[2]"} we do not yet know what it
maps to. There seems more information needed, which we can get by expanding
the header parsing algorithm.
\item \strong{\code{sc_sample_data_param}}: class \code{parameter} (metadata; viewer: "Data
Parameters ScSm"). Describes the \code{sc_sample} data block (see \code{sc_sample}).
\item \strong{\code{sc_sample}}: class \code{data} (spectrum). Single channel (sc) spectrum of
the sample (y-axis: intensity).
\item \strong{\code{ig_sample_data_param}}: class \code{parameter} (metadata; viewer: "Data
Parameters IgSm").
\item \strong{\code{ig_sample}}: class \code{data} (signal, viewer: "IgSm"). Interferogram of
the sample measurement. Oscillatory signal (x-axis: optical path difference
(OPD); y-axis: amplitude of the signal).
\item \strong{\code{sc_ref_data_param}}: class \code{parameter} (metadata; viewer: "Data
Parameters ScRf"). Describes the \code{sc_sample} data block (see \code{sc_ref}).
\item \strong{\code{sc_ref}}: class \code{data} (spectrum; viewer: "Data Parameters IgSm").
Single channel (sc) spectrum of the reference (background material: e.g.,
gold; y-axis: intensity).
\item \strong{\code{ig_ref_data_param}}: class \code{parameter} (metadata; viewer: "Data
Parameters IgRf").
\item \strong{\code{ig_ref}}: class \code{data} (spectrum; viewer: "IgRf"). Interferogram of the
reference measurement. (background material: e.g., gold). Oscillatory
signal (x-axis: optical path difference (OPD); y-axis: amplitude of the
signal)
\item \strong{\code{optics}}: class "parameter (metadata; viewer: "Optic Parameters").
Optic setup and settings such as "Accessory", "Detector Setting" or "Source
Setting".
\item \strong{\code{optics_ref}}: class "parameter (metadata; viewer: "Optic Parameters
Rf"). Optic setup and settings specific to reference measurement such as
"Accessory", "Detector Setting" or "Source Setting".
\item \strong{\code{acquisition_ref}}: class \code{parameter} (metadata; viewer: "Acquisition
parameters Rf". Settings such as ""Additional Data Treatment", (number) of
"Background Scans" or "Result Spectrum" (e.g. value "Absorbance").
\item \strong{\code{fourier_transformation_ref}}: class \code{parameter} (metadata; viewer:
"FT - Parameters Rf"). Fourier transform parameters of the reference
sample like Apodization function ("APF"), end frequency limit ("HFQ"),
start frequency limit ("LFQ"), nonlinearity correction ("NLI"), phase
resolution ("PHR"), phase correction mode ("PHZ"), zero filling factor
("ZFF").
\item \strong{\code{fourier_transformation}}: class \code{parameter} (metadata; viewer:
"FT - Parameters"). Fourier transform parameters of the sample
measurement. See \code{fourier_transformation_ref} for possible elements
contained.
\item \strong{\code{sample}}: class \code{parameter} (metadata; viewer: "Sample Parameters").
Extra information such as the "Operator Name", "Experiment", or "Location".
\item \strong{\code{acquisition}}: class \code{parameter} (metadata; viewer. "Acquisition
Parameters"). Settings of sample measurement, such as "Additional Data
Treatment", (number) of "Background Scans" or "Result Spectrum" (e.g. value
"Absorbance").
\item \strong{\code{instrument_ref}}: class \code{parameter} (metadata; viewer: "Instrument
Parameters Rf"). Detailed instrument properties for the reference
measurement, such as "High Folding Limit", "Number of Sample Scans", or
"Actual Signal Gain 2nd Channel".
\item \strong{\code{instrument}}: class \code{parameter} (metadata; viewer: "Instrument
Parameters"). Detailed instrument properties for the sample measurement.
See \code{instrument_ref}.
\item \strong{\code{lab_and_process_param_raw}}: class \code{parameter} (metadata). Laboratory
sample annotations such as "Product Group", "Product", "Label Product Info
1" (e.g., for \code{sample_id}), "Value Product Info 1" (e.g., the \code{sample_id}
value), or the "Measurement Position Microplate" (e.g., for HTS-XT
extension)
\item \strong{\code{lab_and_process_param_processed}}: class \code{parameter} (metadata).
Laboratory sample annotations for measurements done with additional OPUS
data processing methods. See \code{lab_and_process_param_raw}
\item \strong{\code{info_block}}: class \code{parameter} (metadata). Infos such as "Operator",
measurement "Group", "Sample ID". These can e.g. be set though the OPUS/LAB
sofware interface.
\item \strong{\code{history}}: class \code{parameter} (metadata). Character vector with OPUS
command history.
\item \strong{\code{unknown}}: if a block-type can not be matched, no parsing is done and
an empty list entry is returned. This gives you a hint that there is a block
that can not yet be parsed. You can take further steps by opening an issue.
}
}
\description{
Read and parse OPUS files with spectral data from individual measurements
}
\section{Details}{
 \code{read_opus()} is the high-level interface to read multiple
OPUS files at once from a data source name (\code{dsn}).

It optionally supports parallel reads via the \code{{mirai}} backend. \code{{mirai}}
provides a highly efficient asynchronous parallel evaluation framework via
the Nanomsg Next Gen (NNG), high-performance, lightweight messaging library
for distributed and concurrent applications.

When reading in parallel, a progress bar can be enabled.
}

\concept{core}
