% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocm.methods.R
\name{predict.ocm}
\alias{predict.ocm}
\title{Predict method for Continuous Ordinal Fits}
\usage{
\method{predict}{ocm}(
  object,
  newdata = NULL,
  type = c("response", "density", "CDF", "quantile", "regressor", "exp_regressor",
    "hazard", "cum_hazard", "survival"),
  prob = 1:(K - 1)/K,
  K = 50,
  ...
)
}
\arguments{
\item{object}{an object of class \code{ocm}, usually a result of a call to \code{ocm}}

\item{newdata}{optionally, a data frame in which to look for variables with 
which to predict. 
Note that all predictor variables should be present, having the same names as the variables 
used to fit the model. If \code{NULL}, predictions are computed for the original dataset.}

\item{type}{type of prediction. One of "response" (default), "density", "CDF", "quantile", "regressor", "exp_regressor", "hazard", "cum_hazard" or "survival"}

\item{prob}{probabilities used to evaluate the quantile function (if \code{type="quantile"})}

\item{K}{number of evenly spaced values of \code{v} over which the probability density is evaluated (if \code{type="density"} or \code{type="CDF"}) or number of probabilities at which the quantile function is evaluated (if \code{type="quantile"}). The default is 50.}

\item{...}{further arguments passed to or from other methods}
}
\value{
A vector of predictions, according to the \code{type}.
}
\description{
Predicted values based on \code{ocm} object
}
\details{
An object of class \code{ocm} and optionally a new data 
frame are used to compute the predictions. The estimated parameters 
of the fitted model and \code{K}
values of \code{v} are used to compute the conditional probability density and the conditional cumulative distribution. If a new data frame is used to make predictions, the individual (random) effects are set to zero, while they are maintained to the estimated values if \code{newdata} is NULL.
}
\examples{
\dontrun{
fit.overall <- ocm(overall ~ cycleno + age + bsa + treatment, data=ANZ0001.sub, scale=c(0,100))
pred <- predict(fit.overall)
}
}
\seealso{
\code{\link{ocm}}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\concept{predict}
