% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McCullagh_palindromic_symmetry.R
\name{McCullagh_generalized_palindromic_symmetry}
\alias{McCullagh_generalized_palindromic_symmetry}
\title{Generalized version of palindromic symmetry model}
\usage{
McCullagh_generalized_palindromic_symmetry(
  n,
  max_iter = 15,
  verbose = FALSE,
  start_values = FALSE
)
}
\arguments{
\item{n}{matrix of observed counts}

\item{max_iter}{maximum number of iterations to maximize log(likelihood)}

\item{verbose}{should cycle-by-cycle information be printed out? Default is FALSE,
do not print}

\item{start_values}{logical should the regular palindomic symmetry model be fit first to
get good starting values.  Default is FALSE.}
}
\value{
a list containing

a list containing
   delta: the vector of asymmetry parameter delta
   sigma_delta: vector of SE(delta)
   logL: value of log(likelihood) for final estimates
   chisq: Pearson chi-square for solution
   df: degrees of freedom for solution chisq
   psi: matrix of symmetry parameters
   alpha:
   c: constraint, sum of pi - values
   condition: constraint on psi to make model identified, Lagrange multiplier
   SE: vector of standard errors for all parameters
}
\description{
delta now is a vector, varying by index
McCullagh, P. (1978). A class of parametric models for the analysis of
square contingency tables with ordered categories. Biometrika, 65(2). 413-416.
}
\examples{
McCullagh_generalized_palindromic_symmetry(vision_data)
}
