#' OSM Points Layer for Djibouti, August 2023
#'
#' A data table of all 8608 OSM points in Djibouti as of August 2023.
#'
#' @format
#' A data table with 8608 rows and 10 columns. The first column contains the OSM id of each point. Other columns give the values of frequent OSM tags for point features. The last column is called 'other_tags'  and contains all remaining (less frequent) tags. Please consult the \href{https://wiki.openstreetmap.org/wiki/Map_features}{OSM Feature Documentation} for the exact meaning and frequently used values of these tags.
#'
#' @source
#' Geofabrik download server (https://download.geofabrik.de/). See \link{osmclass-package} for how to download it.
#'
#' @seealso \link{osmclass-package}
#'
#' @examples
#' data(djibouti_points)
'djibouti_points'

