% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique-osmdata.R
\name{unique_osmdata}
\alias{unique_osmdata}
\title{unique_osmdata}
\usage{
unique_osmdata(dat)
}
\arguments{
\item{dat}{An object of class \code{osmdata_sf} or \code{osmdata_sp}}
}
\value{
Equivalent object reduced to only unique objects of each type
}
\description{
Reduce the components of an \link{osmdata} object in 'sf' or 'sp' form (that
is, obtained from \code{\link[=osmdata_sf]{osmdata_sf()}} or \code{\link[=osmdata_sp]{osmdata_sp()}} to only unique
items of each type. That is, reduce \verb{$osm_points} to only those points not
present in other objects (lines, polygons, etc.); reduce \verb{$osm_lines} to
only those lines not present in multiline objects; and reduce
\verb{$osm_polygons} to only those polygons not present in multipolygon
objects. This renders an \link{osmdata} object more directly compatible with
typical output of \pkg{sf}.
}
\examples{
\dontrun{
query <- opq ("colchester uk") |>
    add_osm_feature (key = "highway")
# Then extract data from 'Overpass' API
dat <- osmdata_sf (query)
dat
# Then reduce to unique items of each type only:
dat <- unique_osmdata (dat)
dat
}
# And objects of each type (points, line, polygons, and so on) now have
# fewer members.
}
\seealso{
Other transform: 
\code{\link{osm_elevation}()},
\code{\link{osm_poly2line}()},
\code{\link{trim_osmdata}()},
\code{\link{unname_osmdata_sf}()}
}
\concept{transform}
