% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.objects.summary.R
\name{summary.objects.summary}
\alias{summary.objects.summary}
\title{Summary Method for \code{objects.summary} Objects}
\usage{
\method{summary}{objects.summary}(
  object,
  ...,
  data.class.width = getOption("osum.data.class.width", default = NULL),
  format.extent = getOption("osum.format.extent", default = TRUE)
)
}
\arguments{
\item{object}{object of class \code{objects.summary}}

\item{...}{further arguments to be passed down to \code{summary.data.frame}}

\item{data.class.width}{integer indicating the width of the \code{data.class} field when
it is a list (when \code{objects.summary} was called with \code{all.classes} = \code{TRUE}).
Default: getOption("osum.data.class.width", default = NULL)}

\item{format.extent}{logical indicating whether the \code{extent} field should be formatted as
product (d1 x d2) or left as list (d1, d2). Default: getOption("osum.format.extent", default = TRUE)}
}
\value{
A matrix of class  "\code{\link{table}}", obtained by applying \code{\link{summary}}
to each column of the object (after applying the specific formatting according to the
arguments' values) and collating the results.
}
\description{
Summarize an object of class \code{objects.summary} with some specific formatting
options before using \code{summary.data.frame}.
}
\examples{
os <- objects.summary("package:datasets")
print(summary(os, format.extent = FALSE, maxsum = 10, quantile.type = 7))
print(summary(os, format.extent = TRUE, maxsum = 12, quantile.type = 1))
}
\seealso{
\code{\link{objects.summary}}, \code{\link{summary.data.frame}}, \code{\link{quantile}}
}
