test_that("logger_provider_noop", {
  lp <- logger_provider_noop$new()
  expect_s3_class(lp, "otel_logger_provider")
  expect_s3_class(lp, "otel_logger_provider_noop")
  lgr <- lp$get_logger("test")
  expect_s3_class(lgr, "otel_logger")
  expect_s3_class(lgr, "otel_logger_noop")
})

test_that("logger_noop", {
  lp <- logger_provider_noop$new()
  lgr <- lp$get_logger("test")
  expect_equal(lgr$trace(), lgr)
  expect_equal(lgr$debug(), lgr)
  expect_equal(lgr$info(), lgr)
  expect_equal(lgr$warn(), lgr)
  expect_equal(lgr$error(), lgr)
  expect_equal(lgr$fatal(), lgr)
  expect_equal(lgr$log(), lgr)
  expect_false(lgr$is_enabled())
  expect_equal(lgr$get_minimum_severity(), c("maximumseverity" = 255L))
  expect_equal(lgr$set_minimum_severity(10L), lgr)
  expect_equal(lgr$get_minimum_severity(), c("maximumseverity" = 255L))
})
