% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quiz_formatting.R
\name{check_quiz}
\alias{check_quiz}
\title{Check Quiz}
\usage{
check_quiz(quiz_path, verbose = TRUE, ignore_coursera = TRUE)
}
\arguments{
\item{quiz_path}{A file path to a quiz markdown file}

\item{verbose}{print diagnostic messages? TRUE/FALSE}

\item{ignore_coursera}{Coursera doesn't like `!` or `:` in the quizzes. Do not convert quizzes to coursera and ignore ! and : in question prompts that would not be allowed in Leanpub quizzes when converted to a Coursera quiz. Default is to ignore Coursera compatibility}
}
\value{
A list of checks. "good" means the check passed. Failed checks will report where it failed.
}
\description{
For a file path to a quiz, check whether it is properly formatted for Leanpub.
}
\examples{
\dontrun{

# Take a look at a good quiz's checks:
quiz_path <- good_quiz_path()
good_checks <- check_quiz(quiz_path)

# Take a look at a failed quiz's checks:
quiz_path <- bad_quiz_path()
failed_checks <- check_quiz(quiz_path)
}
}
