% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_without_toc.R
\name{render_without_toc}
\alias{render_without_toc}
\title{Create TOC-less course website for use in Coursera or Leanpub}
\usage{
render_without_toc(
  path = ".",
  output_dir = file.path("docs", "no_toc"),
  output_yaml = "_output.yml",
  convert_quizzes = FALSE,
  input_quiz_dir = "quizzes",
  output_quiz_dir = "coursera_quizzes",
  verbose = TRUE
)
}
\arguments{
\item{path}{path to the bookdown or quarto course repository, must have a `_bookdown.yml` or `_quarto.yml` file}

\item{output_dir}{A folder (existing or not) that the TOC-less Bookdown for Coursera files should be saved. By default is file.path("docs", "coursera")}

\item{output_yaml}{A output.yml file to be provided to bookdown. By default is "_output.yml"}

\item{convert_quizzes}{TRUE/FALSE whether or not to convert quizzes. Default is TRUE}

\item{input_quiz_dir}{A path to a directory of Leanpub-formatted quiz md files. By default assumes "quizzes" and looks in current directory.}

\item{output_quiz_dir}{A folder (existing or not) where the coursera quizzes should be saved. By default is "coursera_quizzes".}

\item{verbose}{Would you like the progress messages? TRUE/FALSE}
}
\value{
A folder of coursera ready quiz files and html chapter files saved to output directories specified.
}
\description{
Create a version of the course that does not have a TOC and has quizzes in the Coursera yaml format.
This is only needed to be used on Bookdown courses. Quarto has a simple command for this.
}
