% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circleRepelLayout.R
\name{circleLayout}
\alias{circleLayout}
\title{Arranges circles by iterative pair-wise repulsion within a bounding rectangle}
\usage{
circleLayout(xyr, xlim, ylim, maxiter = 1000, wrap = TRUE, weights = 1)
}
\arguments{
\item{xyr}{A 3-column matrix or data frame (centre X, centre Y, radius).}

\item{xlim}{The bounds in the X direction; either a vector for [xmin, xmax) 
or a single value interpreted as [0, xmax). Alternatively, omitting this 
argument or passing any of \code{NULL}, a vector of \code{NA} or an empty
vector will result in unbounded movement in the X direction.}

\item{ylim}{The bounds in the Y direction; either a vector for [ymin, ymax) 
or a single value interpreted as [0, ymax). Alternatively, omitting this 
argument or passing any of \code{NULL}, a vector of \code{NA} or an empty
vector will result in unbounded movement in the Y direction.}

\item{maxiter}{The maximum number of iterations.}

\item{wrap}{Whether to treat the bounding rectangle as a toroid (default 
\code{TRUE}). When this is in effect, a circle leaving the bounds on one 
side re-enters on the opposite side.}

\item{weights}{An optional vector of numeric weights (0 to 1 inclusive) to 
apply to the distance each circle moves during pair-repulsion. A weight of 
0 prevents any movement. A weight of 1 gives the default movement distance.
A single value can be supplied for uniform weights. A vector with length 
less than the number of circles will be silently extended by repeating the 
final value. Any values outside the range [0, 1] will be clamped to 0 or 1.}
}
\value{
A list with components: 
  \describe{ 
   \item{layout}{A 3-column matrix or data.frame (centre x, centre y, radius).} 
   \item{niter}{Number of iterations performed.} 
  }
}
\description{
This function is deprecated and will be removed in a future release. 
Please use \code{\link{circleRepelLayout}} instead.
}
\note{
This function assumes that circle sizes are expressed as radii
whereas the default for \code{circleRepelLayout} is area.
}
\seealso{
\code{\link{circleRepelLayout}}
}
