% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customers.R
\name{paddle_list_customer_addresses}
\alias{paddle_list_customer_addresses}
\title{List Addresses for a Customer}
\usage{
paddle_list_customer_addresses(
  id,
  address_id = NULL,
  status = NULL,
  after = NULL,
  order_by = NULL,
  per_page = NULL,
  search = NULL
)
}
\arguments{
\item{id}{Character. Paddle customer ID (e.g., "ctm_abc123"). Required.}

\item{address_id}{Character vector of address IDs (e.g., "add_123"). Optional.}

\item{status}{Character vector. Optional. Valid: "active", "archived".}

\item{after}{Character. Paddle ID to start listing after (for pagination). Optional.}

\item{order_by}{Character. One of `"id[ASC]"`, `"id[DESC]"`. Optional.}

\item{per_page}{Integer. Number of results per page (max 200). Optional.}

\item{search}{Character. Search query across most address fields. Optional. Cannot match `status`, `created_at`, or `updated_at`.}
}
\value{
A list containing address data and pagination metadata.
}
\description{
Fetches a paginated list of addresses associated with a given customer from the Paddle API.
By default, only active addresses are returned.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_list_customer_addresses(id = "ctm_123")
\dontshow{\}) # examplesIf}
}
