% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-example_writing.R
\docType{data}
\name{example_writing_pairs}
\alias{example_writing_pairs}
\title{Example dataset of paired comparisons for writing samples}
\format{
A tibble with 190 rows and 3 variables:
\describe{
\item{ID1}{Character ID of the first sample in the pair.}
\item{ID2}{Character ID of the second sample in the pair.}
\item{better_id}{Character ID of the sample judged better in
this pair (either \code{ID1} or \code{ID2}).}
}
}
\usage{
data("example_writing_pairs")
}
\description{
A complete set of unordered paired comparison outcomes for the
20 samples in \code{\link{example_writing_samples}}. For each
pair of IDs, the \code{better_id} field indicates which sample
is assumed to be better, based on the \code{quality_score} in
\code{example_writing_samples}.
}
\details{
This dataset is useful for demonstrating functions that process
paired comparisons (e.g., building Bradley-Terry data and
fitting \code{\link[sirt]{btm}} models) without requiring any
calls to an LLM.
}
\examples{
data("example_writing_pairs")
head(example_writing_pairs)

}
\keyword{datasets}
