% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai_batch_api.R
\name{openai_download_batch_output}
\alias{openai_download_batch_output}
\title{Download the output file for a completed batch}
\usage{
openai_download_batch_output(batch_id, path, api_key = NULL)
}
\arguments{
\item{batch_id}{The batch ID (e.g. \code{"batch_abc123"}).}

\item{path}{Local file path to write the downloaded \code{.jsonl} output.}

\item{api_key}{Optional OpenAI API key.}
}
\value{
Invisibly, the path to the downloaded file.
}
\description{
Given a batch ID, retrieves the batch metadata, extracts the
\code{output_file_id}, and downloads the corresponding file content to \code{path}.
}
\examples{
\dontrun{
# Requires OPENAI_API_KEY and a completed batch with an output_file_id.

openai_download_batch_output("batch_abc123", "batch_output.jsonl")

# You can then parse the file
res <- parse_openai_batch_output("batch_output.jsonl")
head(res)
}

}
