% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agedepth.2015.r
\name{predict.agelme}
\alias{predict.agelme}
\title{Predicts the Calibrated age for agelme models}
\usage{
\method{predict}{agelme}(object, v = 1, depth, ...)
}
\arguments{
\item{object}{An \code{agelme} model}

\item{v}{Using constant (1) or mu (2) variance}

\item{depth}{A vector of the depths to be predicted}

\item{\dots}{Other arguments, currently unused.}
}
\value{
A list with three items
\describe{
\item{v}{ Whether constant variance or mu variance used.}
\item{fit}{ A data.frame with the model predictions, containing columns:
\describe{
\item{Depth}{ The depths for the predicted ages}
\item{Estage}{ Predicted age}
\item{Lowlim}{ Lower 95 \% confidence interval}
\item{Upplim}{ Upper 95 \% confidence interval}
\item{Tsd}{ Total standard deviation}
}
}
}
\item{data}{ A data.frame containing the age and depth information of the radiocarbon dates.}
}
\description{
This function uses the output from 'agelme' to predict the Calibrated ages
for specified depths.
}
\examples{
data(STOR)

fit.mod <- with(STOR, agelme(depthup, depthdo, cageup, cagedo))

# Predicting using the constant variance model,
# for each cm between 70 and 400 cm.
fit.pre <- predict(fit.mod, 1, 70:400)
plot(fit.pre)
}
\references{
Heegaard, E., Birks, HJB. & Telford, RJ. 2005.
Relationships between calibrated ages and depth in stratigraphical sequences:
an estimation procedure by mixed-effect regression. \emph{The Holocene} \strong{15}: 612-618
\doi{10.1191/0959683605hl836rr}
}
\author{
Einar Heegaard
}
