% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProbOccViaPresAbs.R
\name{getProbOccViaPresAbs}
\alias{getProbOccViaPresAbs}
\title{Estimate the Per-Species Probability of Occurrence as a Function of an Environmental Gradient from Presence-Absence Data}
\usage{
getProbOccViaPresAbs(
  origAbundData,
  gradientOrigDCA,
  occurrenceFloor = 0,
  nBreaksGradientHist = 20
)
}
\arguments{
\item{origAbundData}{The abundance data of the data you wish to model the abundance of.}

\item{gradientOrigDCA}{The environmental gradient along which abundance 
varies, which you are fitting a KDE to.}

\item{occurrenceFloor}{The minimum occurrence for every species, in every bin. 
The default is zero -- increasing this value means every species has a 
non-zero chance of occurring in every bin, which tends to result in wildly 
more diverse assemblages than what is observed in the fossil record, so use with caution.}

\item{nBreaksGradientHist}{The default is 20. Twenty what they asked? Twenty something.}
}
\value{
An approximate function, created with \code{approx} that describes the 
relationship between gradient and probability of occurrence for all species.
}
\description{
This function calculates how species presence (not abundance) varies as a function of an underlying environmental gradient, using only the pattern of presence-absence observed in a given data set (usually data on species abundance).
}
\details{
The rationale for this function was that simulating assemblages using the KDEs of species abundance alone (calculated with \code{getSpeciesSpecificRescaledKDE} tended to create very diversity-high assemblages that did not reflect reality. Accounting for species presence at all using separate models brings simulated assemblages much closer to real assemblages.
}
\examples{

# load data
data(gulfOfAlaska)

alaskaProbOccur <- getProbOccViaPresAbs(
   gradientOrigDCA = DCA1_GOA, 
   origAbundData = abundData_GOA
   )

}
\seealso{
\code{\link{getSpeciesSpecificRescaledKDE}}
}
