% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pam_data.R
\name{read_universal_data}
\alias{read_universal_data}
\title{Read and Process Universal PAM Data}
\usage{
read_universal_data(
  csv_path,
  etr_factor = 0.84,
  fraction_photosystem_I = 0.5,
  fraction_photosystem_II = 0.5
)
}
\arguments{
\item{csv_path}{File path to the CSV file.}

\item{etr_factor}{Numeric. Factor for ETR calculation. Default is \code{0.84}.}

\item{fraction_photosystem_I}{Numeric. Relative distribution of absorbed PAR
to photosystem I. Default is \code{0.5}.}

\item{fraction_photosystem_II}{Numeric. Relative distribution of absorbed PAR
to photosystem II. Default is \code{0.5}.}
}
\value{
A \code{data.table} containing:
\itemize{
  \item \code{par}: Photosynthetically active radiation.
  \item \code{yield_1}: Yield for photosystem I.
  \item \code{yield_2}: Yield for photosystem II.
  \item \code{etr_1}: Calculated ETR for photosystem I.
  \item \code{etr_2}: Calculated ETR for photosystem II.
}
}
\description{
Reads a standardized CSV file containing PAR and yield data for photosystem I and/or II, calculates electron transport rates (ETR), and returns a cleaned and validated dataset. The function is device-agnostic but requires a predefined column structure.
}
\details{
Calculates ETR using:
\deqn{\text{ETR} = \text{PAR} \cdot \text{ETR-Factor} \cdot \text{Fraction of Photosystem (I or II)} \cdot \text{Yield (I or II)}}

A detailed documentation can be found under \url{https://github.com/biotoolbox/pam?tab=readme-ov-file#read_universal_data}
}
\examples{
path <- file.path(system.file("extdata", package = "pam"), "universal_data", "universal_data.csv")
data <- read_universal_data(path)
}
\references{
{
  Heinz Walz GmbH. (2024). \emph{DUAL-PAM-100 DUAL-PAM/F MANUAL, 5th Edition, April 2024, Chapter 7 (pp. 162-172).}
  Heinz Walz GmbH, Effeltrich, Germany.
  Available at: \url{https://www.walz.com/files/downloads/dualpamed05.pdf}
}
}
