% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr_utils.R
\name{ntokens}
\alias{ntokens}
\title{The number of tokens in a string or vector of strings}
\usage{
ntokens(
  x,
  model = getOption("pangoling.causal.default"),
  add_special_tokens = NULL,
  config_tokenizer = NULL
)
}
\arguments{
\item{x}{character input}

\item{model}{Name of a pre-trained model or folder. One should be able to use
models based on "gpt2". See
\href{https://huggingface.co/models?other=gpt2}{hugging face website}.}

\item{add_special_tokens}{Whether to include special tokens. It has the
same default as the
\href{https://huggingface.co/docs/transformers/v4.25.1/en/model_doc/auto#transformers.AutoTokenizer}{AutoTokenizer}
method in Python.}

\item{config_tokenizer}{List with other arguments that control how the
tokenizer from Hugging Face is accessed.}
}
\value{
The number of tokens in a string or vector of words.
}
\description{
The number of tokens in a string or vector of strings
}
\examples{
\dontshow{if (installed_py_pangoling()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ntokens(x = c("The apple doesn't fall far from the tree."), model = "gpt2")
\dontshow{\}) # examplesIf}
}
\seealso{
Other token-related functions: 
\code{\link{tokenize_lst}()},
\code{\link{transformer_vocab}()}
}
\concept{token-related functions}
