% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parglm.R
\name{parglm.control}
\alias{parglm.control}
\title{Auxiliary for Controlling GLM Fitting in Parallel}
\usage{
parglm.control(epsilon = 1e-08, maxit = 25, trace = FALSE,
  nthreads = 1L, block_size = NULL, method = "LINPACK")
}
\arguments{
\item{epsilon}{positive convergence tolerance.}

\item{maxit}{integer giving the maximal number of IWLS iterations.}

\item{trace}{logical indicating if output should be produced doing estimation.}

\item{nthreads}{number of cores to use. You may get the best performance by
using your number of physical cores if your data set is sufficiently large.
Using the number of physical CPUs/cores may yield the best performance
(check your number e.g., by calling \code{parallel::detectCores(logical = FALSE)}).}

\item{block_size}{number of observation to include in each parallel block.}

\item{method}{string specifying which method to use. Either \code{"LINPACK"},
\code{"LAPACK"}, or \code{"FAST"}.}
}
\value{
A list with components named as the arguments.
}
\description{
Auxiliary function for \code{\link{parglm}} fitting.
}
\details{
The \code{LINPACK} method uses the same QR method as \code{\link{glm.fit}} for the final QR decomposition.
This is the \code{dqrdc2} method described in \code{\link[base]{qr}}. All other QR
decompositions but the last are made with \code{DGEQP3} from \code{LAPACK}.
See Wood, Goude, and Shaw (2015) for details on the QR method.

The \code{FAST} method computes the Fisher information and then solves the normal
equation. This is faster but less numerically stable.
}
\examples{
# use one core
clotting <- data.frame(
 u = c(5,10,15,20,30,40,60,80,100),
 lot1 = c(118,58,42,35,27,25,21,19,18),
 lot2 = c(69,35,26,21,18,16,13,12,12))
f1 <- parglm(lot1 ~ log(u), data = clotting, family = Gamma,
             control = parglm.control(nthreads = 1L))

# use two cores
f2 <- parglm(lot1 ~ log(u), data = clotting, family = Gamma,
             control = parglm.control(nthreads = 2L))
all.equal(coef(f1), coef(f2))

}
\references{
Wood, S.N., Goude, Y. & Shaw S. (2015) Generalized additive models for
large datasets. Journal of the Royal Statistical Society, Series C
64(1): 139-155.
}
