% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_haz.R
\name{plot_haz}
\alias{plot_haz}
\title{Plotting parametric hazard curves}
\usage{
plot_haz(data, dist, time = "time", censor = "censor", by = "")
}
\arguments{
\item{data}{A dataframe containing a time column and a censor column.}

\item{dist}{A string name for a distribution that has a corresponding density function and distribution function.
Examples include "norm", "lnorm", "exp", "weibull", "logis", "llogis", "gompertz", etc.}

\item{time}{The string name of the time column of the dataframe. Defaults to "time".}

\item{censor}{The string name of the censor column of the dataframe. 
Defaults to "censor". The censor column must be a numeric indicator variable 
where complete times correspond to a value of 1 and incomplete times correspond to 0.}

\item{by}{The string name of a grouping variable. If specified, multiple lines will be plotted.
Variable can contain logical, string, character, or numeric data.}
}
\description{
Plots hazard curve of right censored data given that it follows a specified parametric distribution.
}
\examples{
data("rearrest")
plot_haz(rearrest, "logis", time = "months")
plot_haz(rearrest, "weibull", time = "months", by = "personal")
}
