% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_sequence.R
\name{find_sequence}
\alias{find_sequence}
\alias{items_are_equal}
\title{Find a code sequence}
\usage{
find_sequence(items, sequence, all = FALSE, ignore_whitespace = TRUE)

items_are_equal(items1, items2)
}
\arguments{
\item{items, sequence}{\link{LaTeX2} objects or lists.}

\item{all}{Whether to return all matches, or just the first.}

\item{ignore_whitespace}{Whether to ignore whitespace in comparisons.}

\item{items1, items2}{Two \link{LaTeX2} or \link{LaTeX2item} objects.}
}
\value{
\code{find_sequence()} returns a \link{LaTeX2range} or list of them where \code{sequence} occurs within \code{items}.

\code{items_are_equal} returns a logical indicator of equality after removing source references.
}
\description{
Find a code sequence
}
\details{
\code{find_sequence()} will only match sequences that
are entirely contained within a single list in \code{items}.
Thus if \code{\link[=prepare_table]{prepare_table()}} is called on a table, then
\code{find_sequence()} will find sequences in the code before
or after the rows, or entirely within a single cell,
but not crossing alignment markers (\code{"&"}).
}
\examples{
find_sequence(parseLatex("a & b & c"), "b & c")
}
