% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naming.R
\name{naming_k}
\alias{naming_k}
\title{Naming convention, which adds k prefix for each key, capitalizes and removes file extension}
\usage{
naming_k(path)
}
\arguments{
\item{path}{full path or its element}
}
\description{
Naming convention, which adds k prefix for each key, capitalizes and removes file extension
}
\examples{
library(magrittr)
naming_k("path/to/myfile.txt")
# Using with full_path_chain
tmp <- create_temp_dir("files")
create_sample_dir(tmp, override = TRUE)
full.path.chain <- full_path_chain(tmp, naming = naming_k)
full.path.chain
tmp <- create_temp_dir("files")
create_sample_dir(tmp)
# Using with path_chain / create_path_chain
path.chain <- path_chain(tmp, naming = naming_k)
path.chain \%>\%
  as.list()
}
