% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{set_traj_frametime}
\alias{set_traj_frametime}
\title{Redefine frames and time stamps on a per-trajectory basis}
\usage{
set_traj_frametime(obj_name)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}
}
\value{
A viewr object (tibble or data.frame with attribute
\code{pathviewr_steps}. New columns include traj_time (the
trajectory-specific time values) and traj_frame (the trajectory-specific
frame numbering).
}
\description{
After a data set has been separated into trajectories, find the earliest
frame in each trajectory and set the corresponding time to 0. All subsequent
time_sec stamps are computed according to successive frame numbering.
}
\details{
The separate_trajectories() and get_full_trajectories() must be
run prior to use. The initial traj_time and traj_frame values are set to 0
within each trajectory.
}
\seealso{
Other utility functions: 
\code{\link{clean_by_span}()},
\code{\link{insert_treatments}()},
\code{\link{remove_duplicate_frames}()},
\code{\link{remove_vel_anomalies}()}
}
\author{
Vikram B. Baliga
}
\concept{utility functions}
