% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourceexplorer_operations.R
\name{resourceexplorer_list_indexes}
\alias{resourceexplorer_list_indexes}
\title{Retrieves a list of all of the indexes in Amazon Web Services Regions
that are currently collecting resource information for Amazon Web
Services Resource Explorer}
\usage{
resourceexplorer_list_indexes(
  MaxResults = NULL,
  NextToken = NULL,
  Regions = NULL,
  Type = NULL
)
}
\arguments{
\item{MaxResults}{The maximum number of results that you want included on each page of the
response. If you do not include this parameter, it defaults to a value
appropriate to the operation. If additional items exist beyond those
included in the current response, the \code{NextToken} response element is
present and has a value (is not null). Include that value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results.

An API operation can return fewer results than the maximum even when
there are more results available. You should check \code{NextToken} after
every operation to ensure that you receive all of the results.}

\item{NextToken}{The parameter for receiving additional results if you receive a
\code{NextToken} response in a previous request. A \code{NextToken} response
indicates that more output is available. Set this parameter to the value
of the previous call's \code{NextToken} response to indicate where the output
should continue from. The pagination tokens expire after 24 hours.}

\item{Regions}{If specified, limits the response to only information about the index in
the specified list of Amazon Web Services Regions.}

\item{Type}{If specified, limits the output to only indexes of the specified Type,
either \code{LOCAL} or \code{AGGREGATOR}.

Use this option to discover the aggregator index for your account.}
}
\description{
Retrieves a list of all of the indexes in Amazon Web Services Regions that are currently collecting resource information for Amazon Web Services Resource Explorer.

See \url{https://www.paws-r-sdk.com/docs/resourceexplorer_list_indexes/} for full documentation.
}
\keyword{internal}
