# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sesv2_service.R
NULL

#' Retrieves batches of metric data collected based on your sending
#' activity
#'
#' @description
#' Retrieves batches of metric data collected based on your sending activity.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_batch_get_metric_data/](https://www.paws-r-sdk.com/docs/sesv2_batch_get_metric_data/) for full documentation.
#'
#' @param Queries &#91;required&#93; A list of queries for metrics to be retrieved.
#'
#' @keywords internal
#'
#' @rdname sesv2_batch_get_metric_data
sesv2_batch_get_metric_data <- function(Queries) {
  op <- new_operation(
    name = "BatchGetMetricData",
    http_method = "POST",
    http_path = "/v2/email/metrics/batch",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$batch_get_metric_data_input(Queries = Queries)
  output <- .sesv2$batch_get_metric_data_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$batch_get_metric_data <- sesv2_batch_get_metric_data

#' Cancels an export job
#'
#' @description
#' Cancels an export job.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_cancel_export_job/](https://www.paws-r-sdk.com/docs/sesv2_cancel_export_job/) for full documentation.
#'
#' @param JobId &#91;required&#93; The export job ID.
#'
#' @keywords internal
#'
#' @rdname sesv2_cancel_export_job
sesv2_cancel_export_job <- function(JobId) {
  op <- new_operation(
    name = "CancelExportJob",
    http_method = "PUT",
    http_path = "/v2/email/export-jobs/{JobId}/cancel",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$cancel_export_job_input(JobId = JobId)
  output <- .sesv2$cancel_export_job_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$cancel_export_job <- sesv2_cancel_export_job

#' Create a configuration set
#'
#' @description
#' Create a configuration set. *Configuration sets* are groups of rules that you can apply to the emails that you send. You apply a configuration set to an email by specifying the name of the configuration set when you call the Amazon SES API v2. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_configuration_set/](https://www.paws-r-sdk.com/docs/sesv2_create_configuration_set/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set. The name can contain up to 64
#' alphanumeric characters, including letters, numbers, hyphens (-) and
#' underscores (_) only.
#' @param TrackingOptions An object that defines the open and click tracking options for emails
#' that you send using the configuration set.
#' @param DeliveryOptions An object that defines the dedicated IP pool that is used to send emails
#' that you send using the configuration set.
#' @param ReputationOptions An object that defines whether or not Amazon SES collects reputation
#' metrics for the emails that you send that use the configuration set.
#' @param SendingOptions An object that defines whether or not Amazon SES can send email that you
#' send using the configuration set.
#' @param Tags An array of objects that define the tags (keys and values) to associate
#' with the configuration set.
#' @param SuppressionOptions 
#' @param VdmOptions An object that defines the VDM options for emails that you send using
#' the configuration set.
#' @param ArchivingOptions An object that defines the MailManager archiving options for emails that
#' you send using the configuration set.
#'
#' @keywords internal
#'
#' @rdname sesv2_create_configuration_set
sesv2_create_configuration_set <- function(ConfigurationSetName, TrackingOptions = NULL, DeliveryOptions = NULL, ReputationOptions = NULL, SendingOptions = NULL, Tags = NULL, SuppressionOptions = NULL, VdmOptions = NULL, ArchivingOptions = NULL) {
  op <- new_operation(
    name = "CreateConfigurationSet",
    http_method = "POST",
    http_path = "/v2/email/configuration-sets",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_configuration_set_input(ConfigurationSetName = ConfigurationSetName, TrackingOptions = TrackingOptions, DeliveryOptions = DeliveryOptions, ReputationOptions = ReputationOptions, SendingOptions = SendingOptions, Tags = Tags, SuppressionOptions = SuppressionOptions, VdmOptions = VdmOptions, ArchivingOptions = ArchivingOptions)
  output <- .sesv2$create_configuration_set_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_configuration_set <- sesv2_create_configuration_set

#' Create an event destination
#'
#' @description
#' Create an event destination. *Events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon EventBridge and associate a rule to send the event to the specified target.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_configuration_set_event_destination/](https://www.paws-r-sdk.com/docs/sesv2_create_configuration_set_event_destination/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set .
#' @param EventDestinationName &#91;required&#93; A name that identifies the event destination within the configuration
#' set.
#' @param EventDestination &#91;required&#93; An object that defines the event destination.
#'
#' @keywords internal
#'
#' @rdname sesv2_create_configuration_set_event_destination
sesv2_create_configuration_set_event_destination <- function(ConfigurationSetName, EventDestinationName, EventDestination) {
  op <- new_operation(
    name = "CreateConfigurationSetEventDestination",
    http_method = "POST",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}/event-destinations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName, EventDestination = EventDestination)
  output <- .sesv2$create_configuration_set_event_destination_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_configuration_set_event_destination <- sesv2_create_configuration_set_event_destination

#' Creates a contact, which is an end-user who is receiving the email, and
#' adds them to a contact list
#'
#' @description
#' Creates a contact, which is an end-user who is receiving the email, and adds them to a contact list.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_contact/](https://www.paws-r-sdk.com/docs/sesv2_create_contact/) for full documentation.
#'
#' @param ContactListName &#91;required&#93; The name of the contact list to which the contact should be added.
#' @param EmailAddress &#91;required&#93; The contact's email address.
#' @param TopicPreferences The contact's preferences for being opted-in to or opted-out of topics.
#' @param UnsubscribeAll A boolean value status noting if the contact is unsubscribed from all
#' contact list topics.
#' @param AttributesData The attribute data attached to a contact.
#'
#' @keywords internal
#'
#' @rdname sesv2_create_contact
sesv2_create_contact <- function(ContactListName, EmailAddress, TopicPreferences = NULL, UnsubscribeAll = NULL, AttributesData = NULL) {
  op <- new_operation(
    name = "CreateContact",
    http_method = "POST",
    http_path = "/v2/email/contact-lists/{ContactListName}/contacts",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_contact_input(ContactListName = ContactListName, EmailAddress = EmailAddress, TopicPreferences = TopicPreferences, UnsubscribeAll = UnsubscribeAll, AttributesData = AttributesData)
  output <- .sesv2$create_contact_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_contact <- sesv2_create_contact

#' Creates a contact list
#'
#' @description
#' Creates a contact list.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_contact_list/](https://www.paws-r-sdk.com/docs/sesv2_create_contact_list/) for full documentation.
#'
#' @param ContactListName &#91;required&#93; The name of the contact list.
#' @param Topics An interest group, theme, or label within a list. A contact list can
#' have multiple topics.
#' @param Description A description of what the contact list is about.
#' @param Tags The tags associated with a contact list.
#'
#' @keywords internal
#'
#' @rdname sesv2_create_contact_list
sesv2_create_contact_list <- function(ContactListName, Topics = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateContactList",
    http_method = "POST",
    http_path = "/v2/email/contact-lists",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_contact_list_input(ContactListName = ContactListName, Topics = Topics, Description = Description, Tags = Tags)
  output <- .sesv2$create_contact_list_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_contact_list <- sesv2_create_contact_list

#' Creates a new custom verification email template
#'
#' @description
#' Creates a new custom verification email template.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_custom_verification_email_template/](https://www.paws-r-sdk.com/docs/sesv2_create_custom_verification_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the custom verification email template.
#' @param FromEmailAddress &#91;required&#93; The email address that the custom verification email is sent from.
#' @param TemplateSubject &#91;required&#93; The subject line of the custom verification email.
#' @param TemplateContent &#91;required&#93; The content of the custom verification email. The total size of the
#' email must be less than 10 MB. The message body may contain HTML, with
#' some limitations. For more information, see [Custom verification email
#' frequently asked
#' questions](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom-faq)
#' in the *Amazon SES Developer Guide*.
#' @param SuccessRedirectionURL &#91;required&#93; The URL that the recipient of the verification email is sent to if his
#' or her address is successfully verified.
#' @param FailureRedirectionURL &#91;required&#93; The URL that the recipient of the verification email is sent to if his
#' or her address is not successfully verified.
#'
#' @keywords internal
#'
#' @rdname sesv2_create_custom_verification_email_template
sesv2_create_custom_verification_email_template <- function(TemplateName, FromEmailAddress, TemplateSubject, TemplateContent, SuccessRedirectionURL, FailureRedirectionURL) {
  op <- new_operation(
    name = "CreateCustomVerificationEmailTemplate",
    http_method = "POST",
    http_path = "/v2/email/custom-verification-email-templates",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_custom_verification_email_template_input(TemplateName = TemplateName, FromEmailAddress = FromEmailAddress, TemplateSubject = TemplateSubject, TemplateContent = TemplateContent, SuccessRedirectionURL = SuccessRedirectionURL, FailureRedirectionURL = FailureRedirectionURL)
  output <- .sesv2$create_custom_verification_email_template_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_custom_verification_email_template <- sesv2_create_custom_verification_email_template

#' Create a new pool of dedicated IP addresses
#'
#' @description
#' Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are associated with your Amazon Web Services account. You can associate a pool with a configuration set. When you send an email that uses that configuration set, the message is sent from one of the addresses in the associated pool.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_dedicated_ip_pool/](https://www.paws-r-sdk.com/docs/sesv2_create_dedicated_ip_pool/) for full documentation.
#'
#' @param PoolName &#91;required&#93; The name of the dedicated IP pool.
#' @param Tags An object that defines the tags (keys and values) that you want to
#' associate with the pool.
#' @param ScalingMode The type of scaling mode.
#'
#' @keywords internal
#'
#' @rdname sesv2_create_dedicated_ip_pool
sesv2_create_dedicated_ip_pool <- function(PoolName, Tags = NULL, ScalingMode = NULL) {
  op <- new_operation(
    name = "CreateDedicatedIpPool",
    http_method = "POST",
    http_path = "/v2/email/dedicated-ip-pools",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_dedicated_ip_pool_input(PoolName = PoolName, Tags = Tags, ScalingMode = ScalingMode)
  output <- .sesv2$create_dedicated_ip_pool_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_dedicated_ip_pool <- sesv2_create_dedicated_ip_pool

#' Create a new predictive inbox placement test
#'
#' @description
#' Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled by various email providers around the world. When you perform a predictive inbox placement test, you provide a sample message that contains the content that you plan to send to your customers. Amazon SES then sends that message to special email addresses spread across several major email providers. After about 24 hours, the test is complete, and you can use the [`get_deliverability_test_report`][sesv2_get_deliverability_test_report] operation to view the results of the test.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_deliverability_test_report/](https://www.paws-r-sdk.com/docs/sesv2_create_deliverability_test_report/) for full documentation.
#'
#' @param ReportName A unique name that helps you to identify the predictive inbox placement
#' test when you retrieve the results.
#' @param FromEmailAddress &#91;required&#93; The email address that the predictive inbox placement test email was
#' sent from.
#' @param Content &#91;required&#93; The HTML body of the message that you sent when you performed the
#' predictive inbox placement test.
#' @param Tags An array of objects that define the tags (keys and values) that you want
#' to associate with the predictive inbox placement test.
#'
#' @keywords internal
#'
#' @rdname sesv2_create_deliverability_test_report
sesv2_create_deliverability_test_report <- function(ReportName = NULL, FromEmailAddress, Content, Tags = NULL) {
  op <- new_operation(
    name = "CreateDeliverabilityTestReport",
    http_method = "POST",
    http_path = "/v2/email/deliverability-dashboard/test",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_deliverability_test_report_input(ReportName = ReportName, FromEmailAddress = FromEmailAddress, Content = Content, Tags = Tags)
  output <- .sesv2$create_deliverability_test_report_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_deliverability_test_report <- sesv2_create_deliverability_test_report

#' Starts the process of verifying an email identity
#'
#' @description
#' Starts the process of verifying an email identity. An *identity* is an email address or domain that you use when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2 permission to send email from the identity.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_email_identity/](https://www.paws-r-sdk.com/docs/sesv2_create_email_identity/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email address or domain to verify.
#' @param Tags An array of objects that define the tags (keys and values) to associate
#' with the email identity.
#' @param DkimSigningAttributes If your request includes this object, Amazon SES configures the identity
#' to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes,
#' or, configures the key length to be used for [Easy
#' DKIM](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
#' 
#' You can only specify this object if the email identity is a domain, as
#' opposed to an address.
#' @param ConfigurationSetName The configuration set to use by default when sending from this identity.
#' Note that any configuration set defined in the email sending request
#' takes precedence.
#'
#' @keywords internal
#'
#' @rdname sesv2_create_email_identity
sesv2_create_email_identity <- function(EmailIdentity, Tags = NULL, DkimSigningAttributes = NULL, ConfigurationSetName = NULL) {
  op <- new_operation(
    name = "CreateEmailIdentity",
    http_method = "POST",
    http_path = "/v2/email/identities",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_email_identity_input(EmailIdentity = EmailIdentity, Tags = Tags, DkimSigningAttributes = DkimSigningAttributes, ConfigurationSetName = ConfigurationSetName)
  output <- .sesv2$create_email_identity_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_email_identity <- sesv2_create_email_identity

#' Creates the specified sending authorization policy for the given
#' identity (an email address or a domain)
#'
#' @description
#' Creates the specified sending authorization policy for the given identity (an email address or a domain).
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_email_identity_policy/](https://www.paws-r-sdk.com/docs/sesv2_create_email_identity_policy/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email identity.
#' @param PolicyName &#91;required&#93; The name of the policy.
#' 
#' The policy name cannot exceed 64 characters and can only include
#' alphanumeric characters, dashes, and underscores.
#' @param Policy &#91;required&#93; The text of the policy in JSON format. The policy cannot exceed 4 KB.
#' 
#' For information about the syntax of sending authorization policies, see
#' the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/).
#'
#' @keywords internal
#'
#' @rdname sesv2_create_email_identity_policy
sesv2_create_email_identity_policy <- function(EmailIdentity, PolicyName, Policy) {
  op <- new_operation(
    name = "CreateEmailIdentityPolicy",
    http_method = "POST",
    http_path = "/v2/email/identities/{EmailIdentity}/policies/{PolicyName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_email_identity_policy_input(EmailIdentity = EmailIdentity, PolicyName = PolicyName, Policy = Policy)
  output <- .sesv2$create_email_identity_policy_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_email_identity_policy <- sesv2_create_email_identity_policy

#' Creates an email template
#'
#' @description
#' Creates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_email_template/](https://www.paws-r-sdk.com/docs/sesv2_create_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the template.
#' @param TemplateContent &#91;required&#93; The content of the email template, composed of a subject line, an HTML
#' part, and a text-only part.
#'
#' @keywords internal
#'
#' @rdname sesv2_create_email_template
sesv2_create_email_template <- function(TemplateName, TemplateContent) {
  op <- new_operation(
    name = "CreateEmailTemplate",
    http_method = "POST",
    http_path = "/v2/email/templates",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_email_template_input(TemplateName = TemplateName, TemplateContent = TemplateContent)
  output <- .sesv2$create_email_template_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_email_template <- sesv2_create_email_template

#' Creates an export job for a data source and destination
#'
#' @description
#' Creates an export job for a data source and destination.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_export_job/](https://www.paws-r-sdk.com/docs/sesv2_create_export_job/) for full documentation.
#'
#' @param ExportDataSource &#91;required&#93; The data source for the export job.
#' @param ExportDestination &#91;required&#93; The destination for the export job.
#'
#' @keywords internal
#'
#' @rdname sesv2_create_export_job
sesv2_create_export_job <- function(ExportDataSource, ExportDestination) {
  op <- new_operation(
    name = "CreateExportJob",
    http_method = "POST",
    http_path = "/v2/email/export-jobs",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_export_job_input(ExportDataSource = ExportDataSource, ExportDestination = ExportDestination)
  output <- .sesv2$create_export_job_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_export_job <- sesv2_create_export_job

#' Creates an import job for a data destination
#'
#' @description
#' Creates an import job for a data destination.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_import_job/](https://www.paws-r-sdk.com/docs/sesv2_create_import_job/) for full documentation.
#'
#' @param ImportDestination &#91;required&#93; The destination for the import job.
#' @param ImportDataSource &#91;required&#93; The data source for the import job.
#'
#' @keywords internal
#'
#' @rdname sesv2_create_import_job
sesv2_create_import_job <- function(ImportDestination, ImportDataSource) {
  op <- new_operation(
    name = "CreateImportJob",
    http_method = "POST",
    http_path = "/v2/email/import-jobs",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_import_job_input(ImportDestination = ImportDestination, ImportDataSource = ImportDataSource)
  output <- .sesv2$create_import_job_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_import_job <- sesv2_create_import_job

#' Creates a multi-region endpoint (global-endpoint)
#'
#' @description
#' Creates a multi-region endpoint (global-endpoint).
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_create_multi_region_endpoint/](https://www.paws-r-sdk.com/docs/sesv2_create_multi_region_endpoint/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the multi-region endpoint (global-endpoint).
#' @param Details &#91;required&#93; Contains details of a multi-region endpoint (global-endpoint) being
#' created.
#' @param Tags An array of objects that define the tags (keys and values) to associate
#' with the multi-region endpoint (global-endpoint).
#'
#' @keywords internal
#'
#' @rdname sesv2_create_multi_region_endpoint
sesv2_create_multi_region_endpoint <- function(EndpointName, Details, Tags = NULL) {
  op <- new_operation(
    name = "CreateMultiRegionEndpoint",
    http_method = "POST",
    http_path = "/v2/email/multi-region-endpoints",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$create_multi_region_endpoint_input(EndpointName = EndpointName, Details = Details, Tags = Tags)
  output <- .sesv2$create_multi_region_endpoint_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$create_multi_region_endpoint <- sesv2_create_multi_region_endpoint

#' Delete an existing configuration set
#'
#' @description
#' Delete an existing configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_delete_configuration_set/](https://www.paws-r-sdk.com/docs/sesv2_delete_configuration_set/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set.
#'
#' @keywords internal
#'
#' @rdname sesv2_delete_configuration_set
sesv2_delete_configuration_set <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteConfigurationSet",
    http_method = "DELETE",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$delete_configuration_set_input(ConfigurationSetName = ConfigurationSetName)
  output <- .sesv2$delete_configuration_set_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$delete_configuration_set <- sesv2_delete_configuration_set

#' Delete an event destination
#'
#' @description
#' Delete an event destination.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_delete_configuration_set_event_destination/](https://www.paws-r-sdk.com/docs/sesv2_delete_configuration_set_event_destination/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that contains the event destination to
#' delete.
#' @param EventDestinationName &#91;required&#93; The name of the event destination to delete.
#'
#' @keywords internal
#'
#' @rdname sesv2_delete_configuration_set_event_destination
sesv2_delete_configuration_set_event_destination <- function(ConfigurationSetName, EventDestinationName) {
  op <- new_operation(
    name = "DeleteConfigurationSetEventDestination",
    http_method = "DELETE",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$delete_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName)
  output <- .sesv2$delete_configuration_set_event_destination_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$delete_configuration_set_event_destination <- sesv2_delete_configuration_set_event_destination

#' Removes a contact from a contact list
#'
#' @description
#' Removes a contact from a contact list.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_delete_contact/](https://www.paws-r-sdk.com/docs/sesv2_delete_contact/) for full documentation.
#'
#' @param ContactListName &#91;required&#93; The name of the contact list from which the contact should be removed.
#' @param EmailAddress &#91;required&#93; The contact's email address.
#'
#' @keywords internal
#'
#' @rdname sesv2_delete_contact
sesv2_delete_contact <- function(ContactListName, EmailAddress) {
  op <- new_operation(
    name = "DeleteContact",
    http_method = "DELETE",
    http_path = "/v2/email/contact-lists/{ContactListName}/contacts/{EmailAddress}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$delete_contact_input(ContactListName = ContactListName, EmailAddress = EmailAddress)
  output <- .sesv2$delete_contact_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$delete_contact <- sesv2_delete_contact

#' Deletes a contact list and all of the contacts on that list
#'
#' @description
#' Deletes a contact list and all of the contacts on that list.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_delete_contact_list/](https://www.paws-r-sdk.com/docs/sesv2_delete_contact_list/) for full documentation.
#'
#' @param ContactListName &#91;required&#93; The name of the contact list.
#'
#' @keywords internal
#'
#' @rdname sesv2_delete_contact_list
sesv2_delete_contact_list <- function(ContactListName) {
  op <- new_operation(
    name = "DeleteContactList",
    http_method = "DELETE",
    http_path = "/v2/email/contact-lists/{ContactListName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$delete_contact_list_input(ContactListName = ContactListName)
  output <- .sesv2$delete_contact_list_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$delete_contact_list <- sesv2_delete_contact_list

#' Deletes an existing custom verification email template
#'
#' @description
#' Deletes an existing custom verification email template.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_delete_custom_verification_email_template/](https://www.paws-r-sdk.com/docs/sesv2_delete_custom_verification_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the custom verification email template that you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname sesv2_delete_custom_verification_email_template
sesv2_delete_custom_verification_email_template <- function(TemplateName) {
  op <- new_operation(
    name = "DeleteCustomVerificationEmailTemplate",
    http_method = "DELETE",
    http_path = "/v2/email/custom-verification-email-templates/{TemplateName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$delete_custom_verification_email_template_input(TemplateName = TemplateName)
  output <- .sesv2$delete_custom_verification_email_template_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$delete_custom_verification_email_template <- sesv2_delete_custom_verification_email_template

#' Delete a dedicated IP pool
#'
#' @description
#' Delete a dedicated IP pool.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_delete_dedicated_ip_pool/](https://www.paws-r-sdk.com/docs/sesv2_delete_dedicated_ip_pool/) for full documentation.
#'
#' @param PoolName &#91;required&#93; The name of the dedicated IP pool that you want to delete.
#'
#' @keywords internal
#'
#' @rdname sesv2_delete_dedicated_ip_pool
sesv2_delete_dedicated_ip_pool <- function(PoolName) {
  op <- new_operation(
    name = "DeleteDedicatedIpPool",
    http_method = "DELETE",
    http_path = "/v2/email/dedicated-ip-pools/{PoolName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$delete_dedicated_ip_pool_input(PoolName = PoolName)
  output <- .sesv2$delete_dedicated_ip_pool_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$delete_dedicated_ip_pool <- sesv2_delete_dedicated_ip_pool

#' Deletes an email identity
#'
#' @description
#' Deletes an email identity. An identity can be either an email address or a domain name.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_delete_email_identity/](https://www.paws-r-sdk.com/docs/sesv2_delete_email_identity/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The identity (that is, the email address or domain) to delete.
#'
#' @keywords internal
#'
#' @rdname sesv2_delete_email_identity
sesv2_delete_email_identity <- function(EmailIdentity) {
  op <- new_operation(
    name = "DeleteEmailIdentity",
    http_method = "DELETE",
    http_path = "/v2/email/identities/{EmailIdentity}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$delete_email_identity_input(EmailIdentity = EmailIdentity)
  output <- .sesv2$delete_email_identity_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$delete_email_identity <- sesv2_delete_email_identity

#' Deletes the specified sending authorization policy for the given
#' identity (an email address or a domain)
#'
#' @description
#' Deletes the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_delete_email_identity_policy/](https://www.paws-r-sdk.com/docs/sesv2_delete_email_identity_policy/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email identity.
#' @param PolicyName &#91;required&#93; The name of the policy.
#' 
#' The policy name cannot exceed 64 characters and can only include
#' alphanumeric characters, dashes, and underscores.
#'
#' @keywords internal
#'
#' @rdname sesv2_delete_email_identity_policy
sesv2_delete_email_identity_policy <- function(EmailIdentity, PolicyName) {
  op <- new_operation(
    name = "DeleteEmailIdentityPolicy",
    http_method = "DELETE",
    http_path = "/v2/email/identities/{EmailIdentity}/policies/{PolicyName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$delete_email_identity_policy_input(EmailIdentity = EmailIdentity, PolicyName = PolicyName)
  output <- .sesv2$delete_email_identity_policy_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$delete_email_identity_policy <- sesv2_delete_email_identity_policy

#' Deletes an email template
#'
#' @description
#' Deletes an email template.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_delete_email_template/](https://www.paws-r-sdk.com/docs/sesv2_delete_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the template to be deleted.
#'
#' @keywords internal
#'
#' @rdname sesv2_delete_email_template
sesv2_delete_email_template <- function(TemplateName) {
  op <- new_operation(
    name = "DeleteEmailTemplate",
    http_method = "DELETE",
    http_path = "/v2/email/templates/{TemplateName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$delete_email_template_input(TemplateName = TemplateName)
  output <- .sesv2$delete_email_template_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$delete_email_template <- sesv2_delete_email_template

#' Deletes a multi-region endpoint (global-endpoint)
#'
#' @description
#' Deletes a multi-region endpoint (global-endpoint).
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_delete_multi_region_endpoint/](https://www.paws-r-sdk.com/docs/sesv2_delete_multi_region_endpoint/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the multi-region endpoint (global-endpoint) to be deleted.
#'
#' @keywords internal
#'
#' @rdname sesv2_delete_multi_region_endpoint
sesv2_delete_multi_region_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "DeleteMultiRegionEndpoint",
    http_method = "DELETE",
    http_path = "/v2/email/multi-region-endpoints/{EndpointName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$delete_multi_region_endpoint_input(EndpointName = EndpointName)
  output <- .sesv2$delete_multi_region_endpoint_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$delete_multi_region_endpoint <- sesv2_delete_multi_region_endpoint

#' Removes an email address from the suppression list for your account
#'
#' @description
#' Removes an email address from the suppression list for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_delete_suppressed_destination/](https://www.paws-r-sdk.com/docs/sesv2_delete_suppressed_destination/) for full documentation.
#'
#' @param EmailAddress &#91;required&#93; The suppressed email destination to remove from the account suppression
#' list.
#'
#' @keywords internal
#'
#' @rdname sesv2_delete_suppressed_destination
sesv2_delete_suppressed_destination <- function(EmailAddress) {
  op <- new_operation(
    name = "DeleteSuppressedDestination",
    http_method = "DELETE",
    http_path = "/v2/email/suppression/addresses/{EmailAddress}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$delete_suppressed_destination_input(EmailAddress = EmailAddress)
  output <- .sesv2$delete_suppressed_destination_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$delete_suppressed_destination <- sesv2_delete_suppressed_destination

#' Obtain information about the email-sending status and capabilities of
#' your Amazon SES account in the current Amazon Web Services Region
#'
#' @description
#' Obtain information about the email-sending status and capabilities of your Amazon SES account in the current Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_account/](https://www.paws-r-sdk.com/docs/sesv2_get_account/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname sesv2_get_account
sesv2_get_account <- function() {
  op <- new_operation(
    name = "GetAccount",
    http_method = "GET",
    http_path = "/v2/email/account",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_account_input()
  output <- .sesv2$get_account_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_account <- sesv2_get_account

#' Retrieve a list of the blacklists that your dedicated IP addresses
#' appear on
#'
#' @description
#' Retrieve a list of the blacklists that your dedicated IP addresses appear on.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_blacklist_reports/](https://www.paws-r-sdk.com/docs/sesv2_get_blacklist_reports/) for full documentation.
#'
#' @param BlacklistItemNames &#91;required&#93; A list of IP addresses that you want to retrieve blacklist information
#' about. You can only specify the dedicated IP addresses that you use to
#' send email using Amazon SES or Amazon Pinpoint.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_blacklist_reports
sesv2_get_blacklist_reports <- function(BlacklistItemNames) {
  op <- new_operation(
    name = "GetBlacklistReports",
    http_method = "GET",
    http_path = "/v2/email/deliverability-dashboard/blacklist-report",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_blacklist_reports_input(BlacklistItemNames = BlacklistItemNames)
  output <- .sesv2$get_blacklist_reports_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_blacklist_reports <- sesv2_get_blacklist_reports

#' Get information about an existing configuration set, including the
#' dedicated IP pool that it's associated with, whether or not it's enabled
#' for sending email, and more
#'
#' @description
#' Get information about an existing configuration set, including the dedicated IP pool that it's associated with, whether or not it's enabled for sending email, and more.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_configuration_set/](https://www.paws-r-sdk.com/docs/sesv2_get_configuration_set/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_configuration_set
sesv2_get_configuration_set <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "GetConfigurationSet",
    http_method = "GET",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_configuration_set_input(ConfigurationSetName = ConfigurationSetName)
  output <- .sesv2$get_configuration_set_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_configuration_set <- sesv2_get_configuration_set

#' Retrieve a list of event destinations that are associated with a
#' configuration set
#'
#' @description
#' Retrieve a list of event destinations that are associated with a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_configuration_set_event_destinations/](https://www.paws-r-sdk.com/docs/sesv2_get_configuration_set_event_destinations/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that contains the event destination.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_configuration_set_event_destinations
sesv2_get_configuration_set_event_destinations <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "GetConfigurationSetEventDestinations",
    http_method = "GET",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}/event-destinations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_configuration_set_event_destinations_input(ConfigurationSetName = ConfigurationSetName)
  output <- .sesv2$get_configuration_set_event_destinations_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_configuration_set_event_destinations <- sesv2_get_configuration_set_event_destinations

#' Returns a contact from a contact list
#'
#' @description
#' Returns a contact from a contact list.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_contact/](https://www.paws-r-sdk.com/docs/sesv2_get_contact/) for full documentation.
#'
#' @param ContactListName &#91;required&#93; The name of the contact list to which the contact belongs.
#' @param EmailAddress &#91;required&#93; The contact's email address.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_contact
sesv2_get_contact <- function(ContactListName, EmailAddress) {
  op <- new_operation(
    name = "GetContact",
    http_method = "GET",
    http_path = "/v2/email/contact-lists/{ContactListName}/contacts/{EmailAddress}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_contact_input(ContactListName = ContactListName, EmailAddress = EmailAddress)
  output <- .sesv2$get_contact_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_contact <- sesv2_get_contact

#' Returns contact list metadata
#'
#' @description
#' Returns contact list metadata. It does not return any information about the contacts present in the list.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_contact_list/](https://www.paws-r-sdk.com/docs/sesv2_get_contact_list/) for full documentation.
#'
#' @param ContactListName &#91;required&#93; The name of the contact list.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_contact_list
sesv2_get_contact_list <- function(ContactListName) {
  op <- new_operation(
    name = "GetContactList",
    http_method = "GET",
    http_path = "/v2/email/contact-lists/{ContactListName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_contact_list_input(ContactListName = ContactListName)
  output <- .sesv2$get_contact_list_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_contact_list <- sesv2_get_contact_list

#' Returns the custom email verification template for the template name you
#' specify
#'
#' @description
#' Returns the custom email verification template for the template name you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_custom_verification_email_template/](https://www.paws-r-sdk.com/docs/sesv2_get_custom_verification_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the custom verification email template that you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_custom_verification_email_template
sesv2_get_custom_verification_email_template <- function(TemplateName) {
  op <- new_operation(
    name = "GetCustomVerificationEmailTemplate",
    http_method = "GET",
    http_path = "/v2/email/custom-verification-email-templates/{TemplateName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_custom_verification_email_template_input(TemplateName = TemplateName)
  output <- .sesv2$get_custom_verification_email_template_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_custom_verification_email_template <- sesv2_get_custom_verification_email_template

#' Get information about a dedicated IP address, including the name of the
#' dedicated IP pool that it's associated with, as well information about
#' the automatic warm-up process for the address
#'
#' @description
#' Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated with, as well information about the automatic warm-up process for the address.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_dedicated_ip/](https://www.paws-r-sdk.com/docs/sesv2_get_dedicated_ip/) for full documentation.
#'
#' @param Ip &#91;required&#93; The IP address that you want to obtain more information about. The value
#' you specify has to be a dedicated IP address that's assocaited with your
#' Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_dedicated_ip
sesv2_get_dedicated_ip <- function(Ip) {
  op <- new_operation(
    name = "GetDedicatedIp",
    http_method = "GET",
    http_path = "/v2/email/dedicated-ips/{IP}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_dedicated_ip_input(Ip = Ip)
  output <- .sesv2$get_dedicated_ip_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_dedicated_ip <- sesv2_get_dedicated_ip

#' Retrieve information about the dedicated pool
#'
#' @description
#' Retrieve information about the dedicated pool.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_dedicated_ip_pool/](https://www.paws-r-sdk.com/docs/sesv2_get_dedicated_ip_pool/) for full documentation.
#'
#' @param PoolName &#91;required&#93; The name of the dedicated IP pool to retrieve.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_dedicated_ip_pool
sesv2_get_dedicated_ip_pool <- function(PoolName) {
  op <- new_operation(
    name = "GetDedicatedIpPool",
    http_method = "GET",
    http_path = "/v2/email/dedicated-ip-pools/{PoolName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_dedicated_ip_pool_input(PoolName = PoolName)
  output <- .sesv2$get_dedicated_ip_pool_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_dedicated_ip_pool <- sesv2_get_dedicated_ip_pool

#' List the dedicated IP addresses that are associated with your Amazon Web
#' Services account
#'
#' @description
#' List the dedicated IP addresses that are associated with your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_dedicated_ips/](https://www.paws-r-sdk.com/docs/sesv2_get_dedicated_ips/) for full documentation.
#'
#' @param PoolName The name of the IP pool that the dedicated IP address is associated
#' with.
#' @param NextToken A token returned from a previous call to
#' [`get_dedicated_ips`][sesv2_get_dedicated_ips] to indicate the position
#' of the dedicated IP pool in the list of IP pools.
#' @param PageSize The number of results to show in a single call to
#' `GetDedicatedIpsRequest`. If the number of results is larger than the
#' number you specified in this parameter, then the response includes a
#' `NextToken` element, which you can use to obtain additional results.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_dedicated_ips
sesv2_get_dedicated_ips <- function(PoolName = NULL, NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "GetDedicatedIps",
    http_method = "GET",
    http_path = "/v2/email/dedicated-ips",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$get_dedicated_ips_input(PoolName = PoolName, NextToken = NextToken, PageSize = PageSize)
  output <- .sesv2$get_dedicated_ips_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_dedicated_ips <- sesv2_get_dedicated_ips

#' Retrieve information about the status of the Deliverability dashboard
#' for your account
#'
#' @description
#' Retrieve information about the status of the Deliverability dashboard for your account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the ability to perform predictive inbox placement tests.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_deliverability_dashboard_options/](https://www.paws-r-sdk.com/docs/sesv2_get_deliverability_dashboard_options/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname sesv2_get_deliverability_dashboard_options
sesv2_get_deliverability_dashboard_options <- function() {
  op <- new_operation(
    name = "GetDeliverabilityDashboardOptions",
    http_method = "GET",
    http_path = "/v2/email/deliverability-dashboard",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_deliverability_dashboard_options_input()
  output <- .sesv2$get_deliverability_dashboard_options_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_deliverability_dashboard_options <- sesv2_get_deliverability_dashboard_options

#' Retrieve the results of a predictive inbox placement test
#'
#' @description
#' Retrieve the results of a predictive inbox placement test.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_deliverability_test_report/](https://www.paws-r-sdk.com/docs/sesv2_get_deliverability_test_report/) for full documentation.
#'
#' @param ReportId &#91;required&#93; A unique string that identifies the predictive inbox placement test.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_deliverability_test_report
sesv2_get_deliverability_test_report <- function(ReportId) {
  op <- new_operation(
    name = "GetDeliverabilityTestReport",
    http_method = "GET",
    http_path = "/v2/email/deliverability-dashboard/test-reports/{ReportId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_deliverability_test_report_input(ReportId = ReportId)
  output <- .sesv2$get_deliverability_test_report_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_deliverability_test_report <- sesv2_get_deliverability_test_report

#' Retrieve all the deliverability data for a specific campaign
#'
#' @description
#' Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_domain_deliverability_campaign/](https://www.paws-r-sdk.com/docs/sesv2_get_domain_deliverability_campaign/) for full documentation.
#'
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign. The Deliverability dashboard
#' automatically generates and assigns this identifier to a campaign.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_domain_deliverability_campaign
sesv2_get_domain_deliverability_campaign <- function(CampaignId) {
  op <- new_operation(
    name = "GetDomainDeliverabilityCampaign",
    http_method = "GET",
    http_path = "/v2/email/deliverability-dashboard/campaigns/{CampaignId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_domain_deliverability_campaign_input(CampaignId = CampaignId)
  output <- .sesv2$get_domain_deliverability_campaign_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_domain_deliverability_campaign <- sesv2_get_domain_deliverability_campaign

#' Retrieve inbox placement and engagement rates for the domains that you
#' use to send email
#'
#' @description
#' Retrieve inbox placement and engagement rates for the domains that you use to send email.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_domain_statistics_report/](https://www.paws-r-sdk.com/docs/sesv2_get_domain_statistics_report/) for full documentation.
#'
#' @param Domain &#91;required&#93; The domain that you want to obtain deliverability metrics for.
#' @param StartDate &#91;required&#93; The first day (in Unix time) that you want to obtain domain
#' deliverability metrics for.
#' @param EndDate &#91;required&#93; The last day (in Unix time) that you want to obtain domain
#' deliverability metrics for. The `EndDate` that you specify has to be
#' less than or equal to 30 days after the `StartDate`.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_domain_statistics_report
sesv2_get_domain_statistics_report <- function(Domain, StartDate, EndDate) {
  op <- new_operation(
    name = "GetDomainStatisticsReport",
    http_method = "GET",
    http_path = "/v2/email/deliverability-dashboard/statistics-report/{Domain}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_domain_statistics_report_input(Domain = Domain, StartDate = StartDate, EndDate = EndDate)
  output <- .sesv2$get_domain_statistics_report_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_domain_statistics_report <- sesv2_get_domain_statistics_report

#' Provides information about a specific identity, including the identity's
#' verification status, sending authorization policies, its DKIM
#' authentication status, and its custom Mail-From settings
#'
#' @description
#' Provides information about a specific identity, including the identity's verification status, sending authorization policies, its DKIM authentication status, and its custom Mail-From settings.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_email_identity/](https://www.paws-r-sdk.com/docs/sesv2_get_email_identity/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email identity.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_email_identity
sesv2_get_email_identity <- function(EmailIdentity) {
  op <- new_operation(
    name = "GetEmailIdentity",
    http_method = "GET",
    http_path = "/v2/email/identities/{EmailIdentity}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_email_identity_input(EmailIdentity = EmailIdentity)
  output <- .sesv2$get_email_identity_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_email_identity <- sesv2_get_email_identity

#' Returns the requested sending authorization policies for the given
#' identity (an email address or a domain)
#'
#' @description
#' Returns the requested sending authorization policies for the given identity (an email address or a domain). The policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a time.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_email_identity_policies/](https://www.paws-r-sdk.com/docs/sesv2_get_email_identity_policies/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email identity.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_email_identity_policies
sesv2_get_email_identity_policies <- function(EmailIdentity) {
  op <- new_operation(
    name = "GetEmailIdentityPolicies",
    http_method = "GET",
    http_path = "/v2/email/identities/{EmailIdentity}/policies",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_email_identity_policies_input(EmailIdentity = EmailIdentity)
  output <- .sesv2$get_email_identity_policies_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_email_identity_policies <- sesv2_get_email_identity_policies

#' Displays the template object (which includes the subject line, HTML part
#' and text part) for the template you specify
#'
#' @description
#' Displays the template object (which includes the subject line, HTML part and text part) for the template you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_email_template/](https://www.paws-r-sdk.com/docs/sesv2_get_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the template.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_email_template
sesv2_get_email_template <- function(TemplateName) {
  op <- new_operation(
    name = "GetEmailTemplate",
    http_method = "GET",
    http_path = "/v2/email/templates/{TemplateName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_email_template_input(TemplateName = TemplateName)
  output <- .sesv2$get_email_template_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_email_template <- sesv2_get_email_template

#' Provides information about an export job
#'
#' @description
#' Provides information about an export job.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_export_job/](https://www.paws-r-sdk.com/docs/sesv2_get_export_job/) for full documentation.
#'
#' @param JobId &#91;required&#93; The export job ID.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_export_job
sesv2_get_export_job <- function(JobId) {
  op <- new_operation(
    name = "GetExportJob",
    http_method = "GET",
    http_path = "/v2/email/export-jobs/{JobId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_export_job_input(JobId = JobId)
  output <- .sesv2$get_export_job_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_export_job <- sesv2_get_export_job

#' Provides information about an import job
#'
#' @description
#' Provides information about an import job.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_import_job/](https://www.paws-r-sdk.com/docs/sesv2_get_import_job/) for full documentation.
#'
#' @param JobId &#91;required&#93; The ID of the import job.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_import_job
sesv2_get_import_job <- function(JobId) {
  op <- new_operation(
    name = "GetImportJob",
    http_method = "GET",
    http_path = "/v2/email/import-jobs/{JobId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_import_job_input(JobId = JobId)
  output <- .sesv2$get_import_job_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_import_job <- sesv2_get_import_job

#' Provides information about a specific message, including the from
#' address, the subject, the recipient address, email tags, as well as
#' events associated with the message
#'
#' @description
#' Provides information about a specific message, including the from address, the subject, the recipient address, email tags, as well as events associated with the message.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_message_insights/](https://www.paws-r-sdk.com/docs/sesv2_get_message_insights/) for full documentation.
#'
#' @param MessageId &#91;required&#93; A `MessageId` is a unique identifier for a message, and is returned when
#' sending emails through Amazon SES.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_message_insights
sesv2_get_message_insights <- function(MessageId) {
  op <- new_operation(
    name = "GetMessageInsights",
    http_method = "GET",
    http_path = "/v2/email/insights/{MessageId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_message_insights_input(MessageId = MessageId)
  output <- .sesv2$get_message_insights_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_message_insights <- sesv2_get_message_insights

#' Displays the multi-region endpoint (global-endpoint) configuration
#'
#' @description
#' Displays the multi-region endpoint (global-endpoint) configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_multi_region_endpoint/](https://www.paws-r-sdk.com/docs/sesv2_get_multi_region_endpoint/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the multi-region endpoint (global-endpoint).
#'
#' @keywords internal
#'
#' @rdname sesv2_get_multi_region_endpoint
sesv2_get_multi_region_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "GetMultiRegionEndpoint",
    http_method = "GET",
    http_path = "/v2/email/multi-region-endpoints/{EndpointName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_multi_region_endpoint_input(EndpointName = EndpointName)
  output <- .sesv2$get_multi_region_endpoint_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_multi_region_endpoint <- sesv2_get_multi_region_endpoint

#' Retrieves information about a specific email address that's on the
#' suppression list for your account
#'
#' @description
#' Retrieves information about a specific email address that's on the suppression list for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_get_suppressed_destination/](https://www.paws-r-sdk.com/docs/sesv2_get_suppressed_destination/) for full documentation.
#'
#' @param EmailAddress &#91;required&#93; The email address that's on the account suppression list.
#'
#' @keywords internal
#'
#' @rdname sesv2_get_suppressed_destination
sesv2_get_suppressed_destination <- function(EmailAddress) {
  op <- new_operation(
    name = "GetSuppressedDestination",
    http_method = "GET",
    http_path = "/v2/email/suppression/addresses/{EmailAddress}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$get_suppressed_destination_input(EmailAddress = EmailAddress)
  output <- .sesv2$get_suppressed_destination_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$get_suppressed_destination <- sesv2_get_suppressed_destination

#' List all of the configuration sets associated with your account in the
#' current region
#'
#' @description
#' List all of the configuration sets associated with your account in the current region.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_configuration_sets/](https://www.paws-r-sdk.com/docs/sesv2_list_configuration_sets/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_configuration_sets`][sesv2_list_configuration_sets] to indicate
#' the position in the list of configuration sets.
#' @param PageSize The number of results to show in a single call to
#' [`list_configuration_sets`][sesv2_list_configuration_sets]. If the
#' number of results is larger than the number you specified in this
#' parameter, then the response includes a `NextToken` element, which you
#' can use to obtain additional results.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_configuration_sets
sesv2_list_configuration_sets <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListConfigurationSets",
    http_method = "GET",
    http_path = "/v2/email/configuration-sets",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_configuration_sets_input(NextToken = NextToken, PageSize = PageSize)
  output <- .sesv2$list_configuration_sets_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_configuration_sets <- sesv2_list_configuration_sets

#' Lists all of the contact lists available
#'
#' @description
#' Lists all of the contact lists available.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_contact_lists/](https://www.paws-r-sdk.com/docs/sesv2_list_contact_lists/) for full documentation.
#'
#' @param PageSize Maximum number of contact lists to return at once. Use this parameter to
#' paginate results. If additional contact lists exist beyond the specified
#' limit, the `NextToken` element is sent in the response. Use the
#' `NextToken` value in subsequent requests to retrieve additional lists.
#' @param NextToken A string token indicating that there might be additional contact lists
#' available to be listed. Use the token provided in the Response to use in
#' the subsequent call to ListContactLists with the same parameters to
#' retrieve the next page of contact lists.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_contact_lists
sesv2_list_contact_lists <- function(PageSize = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListContactLists",
    http_method = "GET",
    http_path = "/v2/email/contact-lists",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_contact_lists_input(PageSize = PageSize, NextToken = NextToken)
  output <- .sesv2$list_contact_lists_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_contact_lists <- sesv2_list_contact_lists

#' Lists the contacts present in a specific contact list
#'
#' @description
#' Lists the contacts present in a specific contact list.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_contacts/](https://www.paws-r-sdk.com/docs/sesv2_list_contacts/) for full documentation.
#'
#' @param ContactListName &#91;required&#93; The name of the contact list.
#' @param Filter A filter that can be applied to a list of contacts.
#' @param PageSize The number of contacts that may be returned at once, which is dependent
#' on if there are more or less contacts than the value of the PageSize.
#' Use this parameter to paginate results. If additional contacts exist
#' beyond the specified limit, the `NextToken` element is sent in the
#' response. Use the `NextToken` value in subsequent requests to retrieve
#' additional contacts.
#' @param NextToken A string token indicating that there might be additional contacts
#' available to be listed. Use the token provided in the Response to use in
#' the subsequent call to ListContacts with the same parameters to retrieve
#' the next page of contacts.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_contacts
sesv2_list_contacts <- function(ContactListName, Filter = NULL, PageSize = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListContacts",
    http_method = "POST",
    http_path = "/v2/email/contact-lists/{ContactListName}/contacts/list",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_contacts_input(ContactListName = ContactListName, Filter = Filter, PageSize = PageSize, NextToken = NextToken)
  output <- .sesv2$list_contacts_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_contacts <- sesv2_list_contacts

#' Lists the existing custom verification email templates for your account
#' in the current Amazon Web Services Region
#'
#' @description
#' Lists the existing custom verification email templates for your account in the current Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_custom_verification_email_templates/](https://www.paws-r-sdk.com/docs/sesv2_list_custom_verification_email_templates/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_custom_verification_email_templates`][sesv2_list_custom_verification_email_templates]
#' to indicate the position in the list of custom verification email
#' templates.
#' @param PageSize The number of results to show in a single call to
#' [`list_custom_verification_email_templates`][sesv2_list_custom_verification_email_templates].
#' If the number of results is larger than the number you specified in this
#' parameter, then the response includes a `NextToken` element, which you
#' can use to obtain additional results.
#' 
#' The value you specify has to be at least 1, and can be no more than 50.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_custom_verification_email_templates
sesv2_list_custom_verification_email_templates <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListCustomVerificationEmailTemplates",
    http_method = "GET",
    http_path = "/v2/email/custom-verification-email-templates",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_custom_verification_email_templates_input(NextToken = NextToken, PageSize = PageSize)
  output <- .sesv2$list_custom_verification_email_templates_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_custom_verification_email_templates <- sesv2_list_custom_verification_email_templates

#' List all of the dedicated IP pools that exist in your Amazon Web
#' Services account in the current Region
#'
#' @description
#' List all of the dedicated IP pools that exist in your Amazon Web Services account in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_dedicated_ip_pools/](https://www.paws-r-sdk.com/docs/sesv2_list_dedicated_ip_pools/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_dedicated_ip_pools`][sesv2_list_dedicated_ip_pools] to indicate
#' the position in the list of dedicated IP pools.
#' @param PageSize The number of results to show in a single call to
#' [`list_dedicated_ip_pools`][sesv2_list_dedicated_ip_pools]. If the
#' number of results is larger than the number you specified in this
#' parameter, then the response includes a `NextToken` element, which you
#' can use to obtain additional results.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_dedicated_ip_pools
sesv2_list_dedicated_ip_pools <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListDedicatedIpPools",
    http_method = "GET",
    http_path = "/v2/email/dedicated-ip-pools",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_dedicated_ip_pools_input(NextToken = NextToken, PageSize = PageSize)
  output <- .sesv2$list_dedicated_ip_pools_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_dedicated_ip_pools <- sesv2_list_dedicated_ip_pools

#' Show a list of the predictive inbox placement tests that you've
#' performed, regardless of their statuses
#'
#' @description
#' Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For predictive inbox placement tests that are complete, you can use the [`get_deliverability_test_report`][sesv2_get_deliverability_test_report] operation to view the results.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_deliverability_test_reports/](https://www.paws-r-sdk.com/docs/sesv2_list_deliverability_test_reports/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_deliverability_test_reports`][sesv2_list_deliverability_test_reports]
#' to indicate the position in the list of predictive inbox placement
#' tests.
#' @param PageSize The number of results to show in a single call to
#' [`list_deliverability_test_reports`][sesv2_list_deliverability_test_reports].
#' If the number of results is larger than the number you specified in this
#' parameter, then the response includes a `NextToken` element, which you
#' can use to obtain additional results.
#' 
#' The value you specify has to be at least 0, and can be no more than
#' 1000.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_deliverability_test_reports
sesv2_list_deliverability_test_reports <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListDeliverabilityTestReports",
    http_method = "GET",
    http_path = "/v2/email/deliverability-dashboard/test-reports",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_deliverability_test_reports_input(NextToken = NextToken, PageSize = PageSize)
  output <- .sesv2$list_deliverability_test_reports_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_deliverability_test_reports <- sesv2_list_deliverability_test_reports

#' Retrieve deliverability data for all the campaigns that used a specific
#' domain to send email during a specified time range
#'
#' @description
#' Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_domain_deliverability_campaigns/](https://www.paws-r-sdk.com/docs/sesv2_list_domain_deliverability_campaigns/) for full documentation.
#'
#' @param StartDate &#91;required&#93; The first day that you want to obtain deliverability data for.
#' @param EndDate &#91;required&#93; The last day that you want to obtain deliverability data for. This value
#' has to be less than or equal to 30 days after the value of the
#' `StartDate` parameter.
#' @param SubscribedDomain &#91;required&#93; The domain to obtain deliverability data for.
#' @param NextToken A token that’s returned from a previous call to the
#' [`list_domain_deliverability_campaigns`][sesv2_list_domain_deliverability_campaigns]
#' operation. This token indicates the position of a campaign in the list
#' of campaigns.
#' @param PageSize The maximum number of results to include in response to a single call to
#' the
#' [`list_domain_deliverability_campaigns`][sesv2_list_domain_deliverability_campaigns]
#' operation. If the number of results is larger than the number that you
#' specify in this parameter, the response includes a `NextToken` element,
#' which you can use to obtain additional results.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_domain_deliverability_campaigns
sesv2_list_domain_deliverability_campaigns <- function(StartDate, EndDate, SubscribedDomain, NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListDomainDeliverabilityCampaigns",
    http_method = "GET",
    http_path = "/v2/email/deliverability-dashboard/domains/{SubscribedDomain}/campaigns",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_domain_deliverability_campaigns_input(StartDate = StartDate, EndDate = EndDate, SubscribedDomain = SubscribedDomain, NextToken = NextToken, PageSize = PageSize)
  output <- .sesv2$list_domain_deliverability_campaigns_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_domain_deliverability_campaigns <- sesv2_list_domain_deliverability_campaigns

#' Returns a list of all of the email identities that are associated with
#' your Amazon Web Services account
#'
#' @description
#' Returns a list of all of the email identities that are associated with your Amazon Web Services account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_email_identities/](https://www.paws-r-sdk.com/docs/sesv2_list_email_identities/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_email_identities`][sesv2_list_email_identities] to indicate the
#' position in the list of identities.
#' @param PageSize The number of results to show in a single call to
#' [`list_email_identities`][sesv2_list_email_identities]. If the number of
#' results is larger than the number you specified in this parameter, then
#' the response includes a `NextToken` element, which you can use to obtain
#' additional results.
#' 
#' The value you specify has to be at least 0, and can be no more than
#' 1000.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_email_identities
sesv2_list_email_identities <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListEmailIdentities",
    http_method = "GET",
    http_path = "/v2/email/identities",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_email_identities_input(NextToken = NextToken, PageSize = PageSize)
  output <- .sesv2$list_email_identities_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_email_identities <- sesv2_list_email_identities

#' Lists the email templates present in your Amazon SES account in the
#' current Amazon Web Services Region
#'
#' @description
#' Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_email_templates/](https://www.paws-r-sdk.com/docs/sesv2_list_email_templates/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_email_templates`][sesv2_list_email_templates] to indicate the
#' position in the list of email templates.
#' @param PageSize The number of results to show in a single call to
#' [`list_email_templates`][sesv2_list_email_templates]. If the number of
#' results is larger than the number you specified in this parameter, then
#' the response includes a `NextToken` element, which you can use to obtain
#' additional results.
#' 
#' The value you specify has to be at least 1, and can be no more than 100.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_email_templates
sesv2_list_email_templates <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListEmailTemplates",
    http_method = "GET",
    http_path = "/v2/email/templates",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_email_templates_input(NextToken = NextToken, PageSize = PageSize)
  output <- .sesv2$list_email_templates_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_email_templates <- sesv2_list_email_templates

#' Lists all of the export jobs
#'
#' @description
#' Lists all of the export jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_export_jobs/](https://www.paws-r-sdk.com/docs/sesv2_list_export_jobs/) for full documentation.
#'
#' @param NextToken The pagination token returned from a previous call to
#' [`list_export_jobs`][sesv2_list_export_jobs] to indicate the position in
#' the list of export jobs.
#' @param PageSize Maximum number of export jobs to return at once. Use this parameter to
#' paginate results. If additional export jobs exist beyond the specified
#' limit, the `NextToken` element is sent in the response. Use the
#' `NextToken` value in subsequent calls to
#' [`list_export_jobs`][sesv2_list_export_jobs] to retrieve additional
#' export jobs.
#' @param ExportSourceType A value used to list export jobs that have a certain `ExportSourceType`.
#' @param JobStatus A value used to list export jobs that have a certain `JobStatus`.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_export_jobs
sesv2_list_export_jobs <- function(NextToken = NULL, PageSize = NULL, ExportSourceType = NULL, JobStatus = NULL) {
  op <- new_operation(
    name = "ListExportJobs",
    http_method = "POST",
    http_path = "/v2/email/list-export-jobs",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_export_jobs_input(NextToken = NextToken, PageSize = PageSize, ExportSourceType = ExportSourceType, JobStatus = JobStatus)
  output <- .sesv2$list_export_jobs_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_export_jobs <- sesv2_list_export_jobs

#' Lists all of the import jobs
#'
#' @description
#' Lists all of the import jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_import_jobs/](https://www.paws-r-sdk.com/docs/sesv2_list_import_jobs/) for full documentation.
#'
#' @param ImportDestinationType The destination of the import job, which can be used to list import jobs
#' that have a certain `ImportDestinationType`.
#' @param NextToken A string token indicating that there might be additional import jobs
#' available to be listed. Copy this token to a subsequent call to
#' [`list_import_jobs`][sesv2_list_import_jobs] with the same parameters to
#' retrieve the next page of import jobs.
#' @param PageSize Maximum number of import jobs to return at once. Use this parameter to
#' paginate results. If additional import jobs exist beyond the specified
#' limit, the `NextToken` element is sent in the response. Use the
#' `NextToken` value in subsequent requests to retrieve additional
#' addresses.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_import_jobs
sesv2_list_import_jobs <- function(ImportDestinationType = NULL, NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListImportJobs",
    http_method = "POST",
    http_path = "/v2/email/import-jobs/list",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_import_jobs_input(ImportDestinationType = ImportDestinationType, NextToken = NextToken, PageSize = PageSize)
  output <- .sesv2$list_import_jobs_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_import_jobs <- sesv2_list_import_jobs

#' List the multi-region endpoints (global-endpoints)
#'
#' @description
#' List the multi-region endpoints (global-endpoints).
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_multi_region_endpoints/](https://www.paws-r-sdk.com/docs/sesv2_list_multi_region_endpoints/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_multi_region_endpoints`][sesv2_list_multi_region_endpoints] to
#' indicate the position in the list of multi-region endpoints
#' (global-endpoints).
#' @param PageSize The number of results to show in a single call to
#' [`list_multi_region_endpoints`][sesv2_list_multi_region_endpoints]. If
#' the number of results is larger than the number you specified in this
#' parameter, the response includes a `NextToken` element that you can use
#' to retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_multi_region_endpoints
sesv2_list_multi_region_endpoints <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListMultiRegionEndpoints",
    http_method = "GET",
    http_path = "/v2/email/multi-region-endpoints",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize", result_key = "MultiRegionEndpoints"),
    stream_api = FALSE
  )
  input <- .sesv2$list_multi_region_endpoints_input(NextToken = NextToken, PageSize = PageSize)
  output <- .sesv2$list_multi_region_endpoints_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_multi_region_endpoints <- sesv2_list_multi_region_endpoints

#' Lists the recommendations present in your Amazon SES account in the
#' current Amazon Web Services Region
#'
#' @description
#' Lists the recommendations present in your Amazon SES account in the current Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_recommendations/](https://www.paws-r-sdk.com/docs/sesv2_list_recommendations/) for full documentation.
#'
#' @param Filter Filters applied when retrieving recommendations. Can eiter be an
#' individual filter, or combinations of `STATUS` and `IMPACT` or `STATUS`
#' and `TYPE`
#' @param NextToken A token returned from a previous call to
#' [`list_recommendations`][sesv2_list_recommendations] to indicate the
#' position in the list of recommendations.
#' @param PageSize The number of results to show in a single call to
#' [`list_recommendations`][sesv2_list_recommendations]. If the number of
#' results is larger than the number you specified in this parameter, then
#' the response includes a `NextToken` element, which you can use to obtain
#' additional results.
#' 
#' The value you specify has to be at least 1, and can be no more than 100.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_recommendations
sesv2_list_recommendations <- function(Filter = NULL, NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListRecommendations",
    http_method = "POST",
    http_path = "/v2/email/vdm/recommendations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_recommendations_input(Filter = Filter, NextToken = NextToken, PageSize = PageSize)
  output <- .sesv2$list_recommendations_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_recommendations <- sesv2_list_recommendations

#' Retrieves a list of email addresses that are on the suppression list for
#' your account
#'
#' @description
#' Retrieves a list of email addresses that are on the suppression list for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_suppressed_destinations/](https://www.paws-r-sdk.com/docs/sesv2_list_suppressed_destinations/) for full documentation.
#'
#' @param Reasons The factors that caused the email address to be added to .
#' @param StartDate Used to filter the list of suppressed email destinations so that it only
#' includes addresses that were added to the list after a specific date.
#' @param EndDate Used to filter the list of suppressed email destinations so that it only
#' includes addresses that were added to the list before a specific date.
#' @param NextToken A token returned from a previous call to
#' [`list_suppressed_destinations`][sesv2_list_suppressed_destinations] to
#' indicate the position in the list of suppressed email addresses.
#' @param PageSize The number of results to show in a single call to
#' [`list_suppressed_destinations`][sesv2_list_suppressed_destinations]. If
#' the number of results is larger than the number you specified in this
#' parameter, then the response includes a `NextToken` element, which you
#' can use to obtain additional results.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_suppressed_destinations
sesv2_list_suppressed_destinations <- function(Reasons = NULL, StartDate = NULL, EndDate = NULL, NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListSuppressedDestinations",
    http_method = "GET",
    http_path = "/v2/email/suppression/addresses",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .sesv2$list_suppressed_destinations_input(Reasons = Reasons, StartDate = StartDate, EndDate = EndDate, NextToken = NextToken, PageSize = PageSize)
  output <- .sesv2$list_suppressed_destinations_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_suppressed_destinations <- sesv2_list_suppressed_destinations

#' Retrieve a list of the tags (keys and values) that are associated with a
#' specified resource
#'
#' @description
#' Retrieve a list of the tags (keys and values) that are associated with a specified resource. A *tag* is a label that you optionally define and associate with a resource. Each tag consists of a required *tag key* and an optional associated *tag value*. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/sesv2_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to retrieve
#' tag information for.
#'
#' @keywords internal
#'
#' @rdname sesv2_list_tags_for_resource
sesv2_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v2/email/tags",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .sesv2$list_tags_for_resource_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$list_tags_for_resource <- sesv2_list_tags_for_resource

#' Enable or disable the automatic warm-up feature for dedicated IP
#' addresses
#'
#' @description
#' Enable or disable the automatic warm-up feature for dedicated IP addresses.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_account_dedicated_ip_warmup_attributes/](https://www.paws-r-sdk.com/docs/sesv2_put_account_dedicated_ip_warmup_attributes/) for full documentation.
#'
#' @param AutoWarmupEnabled Enables or disables the automatic warm-up feature for dedicated IP
#' addresses that are associated with your Amazon SES account in the
#' current Amazon Web Services Region. Set to `true` to enable the
#' automatic warm-up feature, or set to `false` to disable it.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_account_dedicated_ip_warmup_attributes
sesv2_put_account_dedicated_ip_warmup_attributes <- function(AutoWarmupEnabled = NULL) {
  op <- new_operation(
    name = "PutAccountDedicatedIpWarmupAttributes",
    http_method = "PUT",
    http_path = "/v2/email/account/dedicated-ips/warmup",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_account_dedicated_ip_warmup_attributes_input(AutoWarmupEnabled = AutoWarmupEnabled)
  output <- .sesv2$put_account_dedicated_ip_warmup_attributes_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_account_dedicated_ip_warmup_attributes <- sesv2_put_account_dedicated_ip_warmup_attributes

#' Update your Amazon SES account details
#'
#' @description
#' Update your Amazon SES account details.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_account_details/](https://www.paws-r-sdk.com/docs/sesv2_put_account_details/) for full documentation.
#'
#' @param MailType &#91;required&#93; The type of email your account will send.
#' @param WebsiteURL &#91;required&#93; The URL of your website. This information helps us better understand the
#' type of content that you plan to send.
#' @param ContactLanguage The language you would prefer to be contacted with.
#' @param UseCaseDescription A description of the types of email that you plan to send.
#' @param AdditionalContactEmailAddresses Additional email addresses that you would like to be notified regarding
#' Amazon SES matters.
#' @param ProductionAccessEnabled Indicates whether or not your account should have production access in
#' the current Amazon Web Services Region.
#' 
#' If the value is `false`, then your account is in the *sandbox*. When
#' your account is in the sandbox, you can only send email to verified
#' identities.
#' 
#' If the value is `true`, then your account has production access. When
#' your account has production access, you can send email to any address.
#' The sending quota and maximum sending rate for your account vary based
#' on your specific use case.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_account_details
sesv2_put_account_details <- function(MailType, WebsiteURL, ContactLanguage = NULL, UseCaseDescription = NULL, AdditionalContactEmailAddresses = NULL, ProductionAccessEnabled = NULL) {
  op <- new_operation(
    name = "PutAccountDetails",
    http_method = "POST",
    http_path = "/v2/email/account/details",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_account_details_input(MailType = MailType, WebsiteURL = WebsiteURL, ContactLanguage = ContactLanguage, UseCaseDescription = UseCaseDescription, AdditionalContactEmailAddresses = AdditionalContactEmailAddresses, ProductionAccessEnabled = ProductionAccessEnabled)
  output <- .sesv2$put_account_details_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_account_details <- sesv2_put_account_details

#' Enable or disable the ability of your account to send email
#'
#' @description
#' Enable or disable the ability of your account to send email.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_account_sending_attributes/](https://www.paws-r-sdk.com/docs/sesv2_put_account_sending_attributes/) for full documentation.
#'
#' @param SendingEnabled Enables or disables your account's ability to send email. Set to `true`
#' to enable email sending, or set to `false` to disable email sending.
#' 
#' If Amazon Web Services paused your account's ability to send email, you
#' can't use this operation to resume your account's ability to send email.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_account_sending_attributes
sesv2_put_account_sending_attributes <- function(SendingEnabled = NULL) {
  op <- new_operation(
    name = "PutAccountSendingAttributes",
    http_method = "PUT",
    http_path = "/v2/email/account/sending",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_account_sending_attributes_input(SendingEnabled = SendingEnabled)
  output <- .sesv2$put_account_sending_attributes_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_account_sending_attributes <- sesv2_put_account_sending_attributes

#' Change the settings for the account-level suppression list
#'
#' @description
#' Change the settings for the account-level suppression list.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_account_suppression_attributes/](https://www.paws-r-sdk.com/docs/sesv2_put_account_suppression_attributes/) for full documentation.
#'
#' @param SuppressedReasons A list that contains the reasons that email addresses will be
#' automatically added to the suppression list for your account. This list
#' can contain any or all of the following:
#' 
#' -   `COMPLAINT` – Amazon SES adds an email address to the suppression
#'     list for your account when a message sent to that address results in
#'     a complaint.
#' 
#' -   `BOUNCE` – Amazon SES adds an email address to the suppression list
#'     for your account when a message sent to that address results in a
#'     hard bounce.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_account_suppression_attributes
sesv2_put_account_suppression_attributes <- function(SuppressedReasons = NULL) {
  op <- new_operation(
    name = "PutAccountSuppressionAttributes",
    http_method = "PUT",
    http_path = "/v2/email/account/suppression",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_account_suppression_attributes_input(SuppressedReasons = SuppressedReasons)
  output <- .sesv2$put_account_suppression_attributes_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_account_suppression_attributes <- sesv2_put_account_suppression_attributes

#' Update your Amazon SES account VDM attributes
#'
#' @description
#' Update your Amazon SES account VDM attributes.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_account_vdm_attributes/](https://www.paws-r-sdk.com/docs/sesv2_put_account_vdm_attributes/) for full documentation.
#'
#' @param VdmAttributes &#91;required&#93; The VDM attributes that you wish to apply to your Amazon SES account.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_account_vdm_attributes
sesv2_put_account_vdm_attributes <- function(VdmAttributes) {
  op <- new_operation(
    name = "PutAccountVdmAttributes",
    http_method = "PUT",
    http_path = "/v2/email/account/vdm",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_account_vdm_attributes_input(VdmAttributes = VdmAttributes)
  output <- .sesv2$put_account_vdm_attributes_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_account_vdm_attributes <- sesv2_put_account_vdm_attributes

#' Associate the configuration set with a MailManager archive
#'
#' @description
#' Associate the configuration set with a MailManager archive. When you send email using the [`send_email`][sesv2_send_email] or [`send_bulk_email`][sesv2_send_bulk_email] operations the message as it will be given to the receiving SMTP server will be archived, along with the recipient information.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_archiving_options/](https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_archiving_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set to associate with a MailManager
#' archive.
#' @param ArchiveArn The Amazon Resource Name (ARN) of the MailManager archive that the
#' Amazon SES API v2 sends email to.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_configuration_set_archiving_options
sesv2_put_configuration_set_archiving_options <- function(ConfigurationSetName, ArchiveArn = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetArchivingOptions",
    http_method = "PUT",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}/archiving-options",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_configuration_set_archiving_options_input(ConfigurationSetName = ConfigurationSetName, ArchiveArn = ArchiveArn)
  output <- .sesv2$put_configuration_set_archiving_options_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_configuration_set_archiving_options <- sesv2_put_configuration_set_archiving_options

#' Associate a configuration set with a dedicated IP pool
#'
#' @description
#' Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of dedicated IP addresses for sending specific types of email.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_delivery_options/](https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_delivery_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set to associate with a dedicated IP pool.
#' @param TlsPolicy Specifies whether messages that use the configuration set are required
#' to use Transport Layer Security (TLS). If the value is `Require`,
#' messages are only delivered if a TLS connection can be established. If
#' the value is `Optional`, messages can be delivered in plain text if a
#' TLS connection can't be established.
#' @param SendingPoolName The name of the dedicated IP pool to associate with the configuration
#' set.
#' @param MaxDeliverySeconds The maximum amount of time, in seconds, that Amazon SES API v2 will
#' attempt delivery of email. If specified, the value must greater than or
#' equal to 300 seconds (5 minutes) and less than or equal to 50400 seconds
#' (840 minutes).
#'
#' @keywords internal
#'
#' @rdname sesv2_put_configuration_set_delivery_options
sesv2_put_configuration_set_delivery_options <- function(ConfigurationSetName, TlsPolicy = NULL, SendingPoolName = NULL, MaxDeliverySeconds = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetDeliveryOptions",
    http_method = "PUT",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}/delivery-options",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_configuration_set_delivery_options_input(ConfigurationSetName = ConfigurationSetName, TlsPolicy = TlsPolicy, SendingPoolName = SendingPoolName, MaxDeliverySeconds = MaxDeliverySeconds)
  output <- .sesv2$put_configuration_set_delivery_options_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_configuration_set_delivery_options <- sesv2_put_configuration_set_delivery_options

#' Enable or disable collection of reputation metrics for emails that you
#' send using a particular configuration set in a specific Amazon Web
#' Services Region
#'
#' @description
#' Enable or disable collection of reputation metrics for emails that you send using a particular configuration set in a specific Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_reputation_options/](https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_reputation_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set.
#' @param ReputationMetricsEnabled If `true`, tracking of reputation metrics is enabled for the
#' configuration set. If `false`, tracking of reputation metrics is
#' disabled for the configuration set.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_configuration_set_reputation_options
sesv2_put_configuration_set_reputation_options <- function(ConfigurationSetName, ReputationMetricsEnabled = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetReputationOptions",
    http_method = "PUT",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}/reputation-options",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_configuration_set_reputation_options_input(ConfigurationSetName = ConfigurationSetName, ReputationMetricsEnabled = ReputationMetricsEnabled)
  output <- .sesv2$put_configuration_set_reputation_options_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_configuration_set_reputation_options <- sesv2_put_configuration_set_reputation_options

#' Enable or disable email sending for messages that use a particular
#' configuration set in a specific Amazon Web Services Region
#'
#' @description
#' Enable or disable email sending for messages that use a particular configuration set in a specific Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_sending_options/](https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_sending_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set to enable or disable email sending
#' for.
#' @param SendingEnabled If `true`, email sending is enabled for the configuration set. If
#' `false`, email sending is disabled for the configuration set.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_configuration_set_sending_options
sesv2_put_configuration_set_sending_options <- function(ConfigurationSetName, SendingEnabled = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetSendingOptions",
    http_method = "PUT",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}/sending",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_configuration_set_sending_options_input(ConfigurationSetName = ConfigurationSetName, SendingEnabled = SendingEnabled)
  output <- .sesv2$put_configuration_set_sending_options_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_configuration_set_sending_options <- sesv2_put_configuration_set_sending_options

#' Specify the account suppression list preferences for a configuration set
#'
#' @description
#' Specify the account suppression list preferences for a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_suppression_options/](https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_suppression_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set to change the suppression list
#' preferences for.
#' @param SuppressedReasons A list that contains the reasons that email addresses are automatically
#' added to the suppression list for your account. This list can contain
#' any or all of the following:
#' 
#' -   `COMPLAINT` – Amazon SES adds an email address to the suppression
#'     list for your account when a message sent to that address results in
#'     a complaint.
#' 
#' -   `BOUNCE` – Amazon SES adds an email address to the suppression list
#'     for your account when a message sent to that address results in a
#'     hard bounce.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_configuration_set_suppression_options
sesv2_put_configuration_set_suppression_options <- function(ConfigurationSetName, SuppressedReasons = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetSuppressionOptions",
    http_method = "PUT",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}/suppression-options",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_configuration_set_suppression_options_input(ConfigurationSetName = ConfigurationSetName, SuppressedReasons = SuppressedReasons)
  output <- .sesv2$put_configuration_set_suppression_options_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_configuration_set_suppression_options <- sesv2_put_configuration_set_suppression_options

#' Specify a custom domain to use for open and click tracking elements in
#' email that you send
#'
#' @description
#' Specify a custom domain to use for open and click tracking elements in email that you send.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_tracking_options/](https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_tracking_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set.
#' @param CustomRedirectDomain The domain to use to track open and click events.
#' @param HttpsPolicy 
#'
#' @keywords internal
#'
#' @rdname sesv2_put_configuration_set_tracking_options
sesv2_put_configuration_set_tracking_options <- function(ConfigurationSetName, CustomRedirectDomain = NULL, HttpsPolicy = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetTrackingOptions",
    http_method = "PUT",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}/tracking-options",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_configuration_set_tracking_options_input(ConfigurationSetName = ConfigurationSetName, CustomRedirectDomain = CustomRedirectDomain, HttpsPolicy = HttpsPolicy)
  output <- .sesv2$put_configuration_set_tracking_options_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_configuration_set_tracking_options <- sesv2_put_configuration_set_tracking_options

#' Specify VDM preferences for email that you send using the configuration
#' set
#'
#' @description
#' Specify VDM preferences for email that you send using the configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_vdm_options/](https://www.paws-r-sdk.com/docs/sesv2_put_configuration_set_vdm_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set.
#' @param VdmOptions The VDM options to apply to the configuration set.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_configuration_set_vdm_options
sesv2_put_configuration_set_vdm_options <- function(ConfigurationSetName, VdmOptions = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetVdmOptions",
    http_method = "PUT",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}/vdm-options",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_configuration_set_vdm_options_input(ConfigurationSetName = ConfigurationSetName, VdmOptions = VdmOptions)
  output <- .sesv2$put_configuration_set_vdm_options_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_configuration_set_vdm_options <- sesv2_put_configuration_set_vdm_options

#' Move a dedicated IP address to an existing dedicated IP pool
#'
#' @description
#' Move a dedicated IP address to an existing dedicated IP pool.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_dedicated_ip_in_pool/](https://www.paws-r-sdk.com/docs/sesv2_put_dedicated_ip_in_pool/) for full documentation.
#'
#' @param Ip &#91;required&#93; The IP address that you want to move to the dedicated IP pool. The value
#' you specify has to be a dedicated IP address that's associated with your
#' Amazon Web Services account.
#' @param DestinationPoolName &#91;required&#93; The name of the IP pool that you want to add the dedicated IP address
#' to. You have to specify an IP pool that already exists.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_dedicated_ip_in_pool
sesv2_put_dedicated_ip_in_pool <- function(Ip, DestinationPoolName) {
  op <- new_operation(
    name = "PutDedicatedIpInPool",
    http_method = "PUT",
    http_path = "/v2/email/dedicated-ips/{IP}/pool",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_dedicated_ip_in_pool_input(Ip = Ip, DestinationPoolName = DestinationPoolName)
  output <- .sesv2$put_dedicated_ip_in_pool_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_dedicated_ip_in_pool <- sesv2_put_dedicated_ip_in_pool

#' Used to convert a dedicated IP pool to a different scaling mode
#'
#' @description
#' Used to convert a dedicated IP pool to a different scaling mode.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_dedicated_ip_pool_scaling_attributes/](https://www.paws-r-sdk.com/docs/sesv2_put_dedicated_ip_pool_scaling_attributes/) for full documentation.
#'
#' @param PoolName &#91;required&#93; The name of the dedicated IP pool.
#' @param ScalingMode &#91;required&#93; The scaling mode to apply to the dedicated IP pool.
#' 
#' Changing the scaling mode from `MANAGED` to `STANDARD` is not supported.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_dedicated_ip_pool_scaling_attributes
sesv2_put_dedicated_ip_pool_scaling_attributes <- function(PoolName, ScalingMode) {
  op <- new_operation(
    name = "PutDedicatedIpPoolScalingAttributes",
    http_method = "PUT",
    http_path = "/v2/email/dedicated-ip-pools/{PoolName}/scaling",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_dedicated_ip_pool_scaling_attributes_input(PoolName = PoolName, ScalingMode = ScalingMode)
  output <- .sesv2$put_dedicated_ip_pool_scaling_attributes_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_dedicated_ip_pool_scaling_attributes <- sesv2_put_dedicated_ip_pool_scaling_attributes

#' Put dedicated ip warmup attributes
#'
#' @description
#' Put dedicated ip warmup attributes
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_dedicated_ip_warmup_attributes/](https://www.paws-r-sdk.com/docs/sesv2_put_dedicated_ip_warmup_attributes/) for full documentation.
#'
#' @param Ip &#91;required&#93; The dedicated IP address that you want to update the warm-up attributes
#' for.
#' @param WarmupPercentage &#91;required&#93; The warm-up percentage that you want to associate with the dedicated IP
#' address.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_dedicated_ip_warmup_attributes
sesv2_put_dedicated_ip_warmup_attributes <- function(Ip, WarmupPercentage) {
  op <- new_operation(
    name = "PutDedicatedIpWarmupAttributes",
    http_method = "PUT",
    http_path = "/v2/email/dedicated-ips/{IP}/warmup",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_dedicated_ip_warmup_attributes_input(Ip = Ip, WarmupPercentage = WarmupPercentage)
  output <- .sesv2$put_dedicated_ip_warmup_attributes_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_dedicated_ip_warmup_attributes <- sesv2_put_dedicated_ip_warmup_attributes

#' Enable or disable the Deliverability dashboard
#'
#' @description
#' Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the ability to perform predictive inbox placement tests.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_deliverability_dashboard_option/](https://www.paws-r-sdk.com/docs/sesv2_put_deliverability_dashboard_option/) for full documentation.
#'
#' @param DashboardEnabled &#91;required&#93; Specifies whether to enable the Deliverability dashboard. To enable the
#' dashboard, set this value to `true`.
#' @param SubscribedDomains An array of objects, one for each verified domain that you use to send
#' email and enabled the Deliverability dashboard for.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_deliverability_dashboard_option
sesv2_put_deliverability_dashboard_option <- function(DashboardEnabled, SubscribedDomains = NULL) {
  op <- new_operation(
    name = "PutDeliverabilityDashboardOption",
    http_method = "PUT",
    http_path = "/v2/email/deliverability-dashboard",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_deliverability_dashboard_option_input(DashboardEnabled = DashboardEnabled, SubscribedDomains = SubscribedDomains)
  output <- .sesv2$put_deliverability_dashboard_option_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_deliverability_dashboard_option <- sesv2_put_deliverability_dashboard_option

#' Used to associate a configuration set with an email identity
#'
#' @description
#' Used to associate a configuration set with an email identity.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_email_identity_configuration_set_attributes/](https://www.paws-r-sdk.com/docs/sesv2_put_email_identity_configuration_set_attributes/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email address or domain to associate with a configuration set.
#' @param ConfigurationSetName The configuration set to associate with an email identity.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_email_identity_configuration_set_attributes
sesv2_put_email_identity_configuration_set_attributes <- function(EmailIdentity, ConfigurationSetName = NULL) {
  op <- new_operation(
    name = "PutEmailIdentityConfigurationSetAttributes",
    http_method = "PUT",
    http_path = "/v2/email/identities/{EmailIdentity}/configuration-set",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_email_identity_configuration_set_attributes_input(EmailIdentity = EmailIdentity, ConfigurationSetName = ConfigurationSetName)
  output <- .sesv2$put_email_identity_configuration_set_attributes_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_email_identity_configuration_set_attributes <- sesv2_put_email_identity_configuration_set_attributes

#' Used to enable or disable DKIM authentication for an email identity
#'
#' @description
#' Used to enable or disable DKIM authentication for an email identity.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_email_identity_dkim_attributes/](https://www.paws-r-sdk.com/docs/sesv2_put_email_identity_dkim_attributes/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email identity.
#' @param SigningEnabled Sets the DKIM signing configuration for the identity.
#' 
#' When you set this value `true`, then the messages that are sent from the
#' identity are signed using DKIM. If you set this value to `false`, your
#' messages are sent without DKIM signing.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_email_identity_dkim_attributes
sesv2_put_email_identity_dkim_attributes <- function(EmailIdentity, SigningEnabled = NULL) {
  op <- new_operation(
    name = "PutEmailIdentityDkimAttributes",
    http_method = "PUT",
    http_path = "/v2/email/identities/{EmailIdentity}/dkim",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_email_identity_dkim_attributes_input(EmailIdentity = EmailIdentity, SigningEnabled = SigningEnabled)
  output <- .sesv2$put_email_identity_dkim_attributes_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_email_identity_dkim_attributes <- sesv2_put_email_identity_dkim_attributes

#' Used to configure or change the DKIM authentication settings for an
#' email domain identity
#'
#' @description
#' Used to configure or change the DKIM authentication settings for an email domain identity. You can use this operation to do any of the following:
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_email_identity_dkim_signing_attributes/](https://www.paws-r-sdk.com/docs/sesv2_put_email_identity_dkim_signing_attributes/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email identity.
#' @param SigningAttributesOrigin &#91;required&#93; The method to use to configure DKIM for the identity. There are the
#' following possible values:
#' 
#' -   `AWS_SES` – Configure DKIM for the identity by using [Easy
#'     DKIM](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
#' 
#' -   `EXTERNAL` – Configure DKIM for the identity by using Bring Your Own
#'     DKIM (BYODKIM).
#' @param SigningAttributes An object that contains information about the private key and selector
#' that you want to use to configure DKIM for the identity for Bring Your
#' Own DKIM (BYODKIM) for the identity, or, configures the key length to be
#' used for [Easy
#' DKIM](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
#'
#' @keywords internal
#'
#' @rdname sesv2_put_email_identity_dkim_signing_attributes
sesv2_put_email_identity_dkim_signing_attributes <- function(EmailIdentity, SigningAttributesOrigin, SigningAttributes = NULL) {
  op <- new_operation(
    name = "PutEmailIdentityDkimSigningAttributes",
    http_method = "PUT",
    http_path = "/v1/email/identities/{EmailIdentity}/dkim/signing",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_email_identity_dkim_signing_attributes_input(EmailIdentity = EmailIdentity, SigningAttributesOrigin = SigningAttributesOrigin, SigningAttributes = SigningAttributes)
  output <- .sesv2$put_email_identity_dkim_signing_attributes_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_email_identity_dkim_signing_attributes <- sesv2_put_email_identity_dkim_signing_attributes

#' Used to enable or disable feedback forwarding for an identity
#'
#' @description
#' Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_email_identity_feedback_attributes/](https://www.paws-r-sdk.com/docs/sesv2_put_email_identity_feedback_attributes/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email identity.
#' @param EmailForwardingEnabled Sets the feedback forwarding configuration for the identity.
#' 
#' If the value is `true`, you receive email notifications when bounce or
#' complaint events occur. These notifications are sent to the address that
#' you specified in the `Return-Path` header of the original email.
#' 
#' You're required to have a method of tracking bounces and complaints. If
#' you haven't set up another mechanism for receiving bounce or complaint
#' notifications (for example, by setting up an event destination), you
#' receive an email notification when these events occur (even if this
#' setting is disabled).
#'
#' @keywords internal
#'
#' @rdname sesv2_put_email_identity_feedback_attributes
sesv2_put_email_identity_feedback_attributes <- function(EmailIdentity, EmailForwardingEnabled = NULL) {
  op <- new_operation(
    name = "PutEmailIdentityFeedbackAttributes",
    http_method = "PUT",
    http_path = "/v2/email/identities/{EmailIdentity}/feedback",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_email_identity_feedback_attributes_input(EmailIdentity = EmailIdentity, EmailForwardingEnabled = EmailForwardingEnabled)
  output <- .sesv2$put_email_identity_feedback_attributes_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_email_identity_feedback_attributes <- sesv2_put_email_identity_feedback_attributes

#' Used to enable or disable the custom Mail-From domain configuration for
#' an email identity
#'
#' @description
#' Used to enable or disable the custom Mail-From domain configuration for an email identity.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_email_identity_mail_from_attributes/](https://www.paws-r-sdk.com/docs/sesv2_put_email_identity_mail_from_attributes/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The verified email identity.
#' @param MailFromDomain The custom MAIL FROM domain that you want the verified identity to use.
#' The MAIL FROM domain must meet the following criteria:
#' 
#' -   It has to be a subdomain of the verified identity.
#' 
#' -   It can't be used to receive email.
#' 
#' -   It can't be used in a "From" address if the MAIL FROM domain is a
#'     destination for feedback forwarding emails.
#' @param BehaviorOnMxFailure The action to take if the required MX record isn't found when you send
#' an email. When you set this value to `UseDefaultValue`, the mail is sent
#' using *amazonses.com* as the MAIL FROM domain. When you set this value
#' to `RejectMessage`, the Amazon SES API v2 returns a
#' `MailFromDomainNotVerified` error, and doesn't attempt to deliver the
#' email.
#' 
#' These behaviors are taken when the custom MAIL FROM domain configuration
#' is in the `Pending`, `Failed`, and `TemporaryFailure` states.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_email_identity_mail_from_attributes
sesv2_put_email_identity_mail_from_attributes <- function(EmailIdentity, MailFromDomain = NULL, BehaviorOnMxFailure = NULL) {
  op <- new_operation(
    name = "PutEmailIdentityMailFromAttributes",
    http_method = "PUT",
    http_path = "/v2/email/identities/{EmailIdentity}/mail-from",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_email_identity_mail_from_attributes_input(EmailIdentity = EmailIdentity, MailFromDomain = MailFromDomain, BehaviorOnMxFailure = BehaviorOnMxFailure)
  output <- .sesv2$put_email_identity_mail_from_attributes_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_email_identity_mail_from_attributes <- sesv2_put_email_identity_mail_from_attributes

#' Adds an email address to the suppression list for your account
#'
#' @description
#' Adds an email address to the suppression list for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_put_suppressed_destination/](https://www.paws-r-sdk.com/docs/sesv2_put_suppressed_destination/) for full documentation.
#'
#' @param EmailAddress &#91;required&#93; The email address that should be added to the suppression list for your
#' account.
#' @param Reason &#91;required&#93; The factors that should cause the email address to be added to the
#' suppression list for your account.
#'
#' @keywords internal
#'
#' @rdname sesv2_put_suppressed_destination
sesv2_put_suppressed_destination <- function(EmailAddress, Reason) {
  op <- new_operation(
    name = "PutSuppressedDestination",
    http_method = "PUT",
    http_path = "/v2/email/suppression/addresses",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$put_suppressed_destination_input(EmailAddress = EmailAddress, Reason = Reason)
  output <- .sesv2$put_suppressed_destination_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$put_suppressed_destination <- sesv2_put_suppressed_destination

#' Composes an email message to multiple destinations
#'
#' @description
#' Composes an email message to multiple destinations.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_send_bulk_email/](https://www.paws-r-sdk.com/docs/sesv2_send_bulk_email/) for full documentation.
#'
#' @param FromEmailAddress The email address to use as the "From" address for the email. The
#' address that you specify has to be verified.
#' @param FromEmailAddressIdentityArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the email address specified in the
#' `FromEmailAddress` parameter.
#' 
#' For example, if the owner of example.com (which has ARN
#' arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a
#' policy to it that authorizes you to use sender@@example.com, then you
#' would specify the `FromEmailAddressIdentityArn` to be
#' arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
#' `FromEmailAddress` to be sender@@example.com.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' @param ReplyToAddresses The "Reply-to" email addresses for the message. When the recipient
#' replies to the message, each Reply-to address receives the reply.
#' @param FeedbackForwardingEmailAddress The address that you want bounce and complaint notifications to be sent
#' to.
#' @param FeedbackForwardingEmailAddressIdentityArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the email address specified in the
#' `FeedbackForwardingEmailAddress` parameter.
#' 
#' For example, if the owner of example.com (which has ARN
#' arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a
#' policy to it that authorizes you to use feedback@@example.com, then you
#' would specify the `FeedbackForwardingEmailAddressIdentityArn` to be
#' arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
#' `FeedbackForwardingEmailAddress` to be feedback@@example.com.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' @param DefaultEmailTags A list of tags, in the form of name/value pairs, to apply to an email
#' that you send using the [`send_email`][sesv2_send_email] operation. Tags
#' correspond to characteristics of the email that you define, so that you
#' can publish email sending events.
#' @param DefaultContent &#91;required&#93; An object that contains the body of the message. You can specify a
#' template message.
#' @param BulkEmailEntries &#91;required&#93; The list of bulk email entry objects.
#' @param ConfigurationSetName The name of the configuration set to use when sending the email.
#' @param EndpointId The ID of the multi-region endpoint (global-endpoint).
#'
#' @keywords internal
#'
#' @rdname sesv2_send_bulk_email
sesv2_send_bulk_email <- function(FromEmailAddress = NULL, FromEmailAddressIdentityArn = NULL, ReplyToAddresses = NULL, FeedbackForwardingEmailAddress = NULL, FeedbackForwardingEmailAddressIdentityArn = NULL, DefaultEmailTags = NULL, DefaultContent, BulkEmailEntries, ConfigurationSetName = NULL, EndpointId = NULL) {
  op <- new_operation(
    name = "SendBulkEmail",
    http_method = "POST",
    http_path = "/v2/email/outbound-bulk-emails",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$send_bulk_email_input(FromEmailAddress = FromEmailAddress, FromEmailAddressIdentityArn = FromEmailAddressIdentityArn, ReplyToAddresses = ReplyToAddresses, FeedbackForwardingEmailAddress = FeedbackForwardingEmailAddress, FeedbackForwardingEmailAddressIdentityArn = FeedbackForwardingEmailAddressIdentityArn, DefaultEmailTags = DefaultEmailTags, DefaultContent = DefaultContent, BulkEmailEntries = BulkEmailEntries, ConfigurationSetName = ConfigurationSetName, EndpointId = EndpointId)
  output <- .sesv2$send_bulk_email_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$send_bulk_email <- sesv2_send_bulk_email

#' Adds an email address to the list of identities for your Amazon SES
#' account in the current Amazon Web Services Region and attempts to verify
#' it
#'
#' @description
#' Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it. As a result of executing this operation, a customized verification email is sent to the specified address.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_send_custom_verification_email/](https://www.paws-r-sdk.com/docs/sesv2_send_custom_verification_email/) for full documentation.
#'
#' @param EmailAddress &#91;required&#93; The email address to verify.
#' @param TemplateName &#91;required&#93; The name of the custom verification email template to use when sending
#' the verification email.
#' @param ConfigurationSetName Name of a configuration set to use when sending the verification email.
#'
#' @keywords internal
#'
#' @rdname sesv2_send_custom_verification_email
sesv2_send_custom_verification_email <- function(EmailAddress, TemplateName, ConfigurationSetName = NULL) {
  op <- new_operation(
    name = "SendCustomVerificationEmail",
    http_method = "POST",
    http_path = "/v2/email/outbound-custom-verification-emails",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$send_custom_verification_email_input(EmailAddress = EmailAddress, TemplateName = TemplateName, ConfigurationSetName = ConfigurationSetName)
  output <- .sesv2$send_custom_verification_email_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$send_custom_verification_email <- sesv2_send_custom_verification_email

#' Sends an email message
#'
#' @description
#' Sends an email message. You can use the Amazon SES API v2 to send the following types of messages:
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_send_email/](https://www.paws-r-sdk.com/docs/sesv2_send_email/) for full documentation.
#'
#' @param FromEmailAddress The email address to use as the "From" address for the email. The
#' address that you specify has to be verified.
#' @param FromEmailAddressIdentityArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the email address specified in the
#' `FromEmailAddress` parameter.
#' 
#' For example, if the owner of example.com (which has ARN
#' arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a
#' policy to it that authorizes you to use sender@@example.com, then you
#' would specify the `FromEmailAddressIdentityArn` to be
#' arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
#' `FromEmailAddress` to be sender@@example.com.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' 
#' For Raw emails, the `FromEmailAddressIdentityArn` value overrides the
#' X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email
#' message content.
#' @param Destination An object that contains the recipients of the email message.
#' @param ReplyToAddresses The "Reply-to" email addresses for the message. When the recipient
#' replies to the message, each Reply-to address receives the reply.
#' @param FeedbackForwardingEmailAddress The address that you want bounce and complaint notifications to be sent
#' to.
#' @param FeedbackForwardingEmailAddressIdentityArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the email address specified in the
#' `FeedbackForwardingEmailAddress` parameter.
#' 
#' For example, if the owner of example.com (which has ARN
#' arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a
#' policy to it that authorizes you to use feedback@@example.com, then you
#' would specify the `FeedbackForwardingEmailAddressIdentityArn` to be
#' arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
#' `FeedbackForwardingEmailAddress` to be feedback@@example.com.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' @param Content &#91;required&#93; An object that contains the body of the message. You can send either a
#' Simple message, Raw message, or a Templated message.
#' @param EmailTags A list of tags, in the form of name/value pairs, to apply to an email
#' that you send using the [`send_email`][sesv2_send_email] operation. Tags
#' correspond to characteristics of the email that you define, so that you
#' can publish email sending events.
#' @param ConfigurationSetName The name of the configuration set to use when sending the email.
#' @param EndpointId The ID of the multi-region endpoint (global-endpoint).
#' @param ListManagementOptions An object used to specify a list or topic to which an email belongs,
#' which will be used when a contact chooses to unsubscribe.
#'
#' @keywords internal
#'
#' @rdname sesv2_send_email
sesv2_send_email <- function(FromEmailAddress = NULL, FromEmailAddressIdentityArn = NULL, Destination = NULL, ReplyToAddresses = NULL, FeedbackForwardingEmailAddress = NULL, FeedbackForwardingEmailAddressIdentityArn = NULL, Content, EmailTags = NULL, ConfigurationSetName = NULL, EndpointId = NULL, ListManagementOptions = NULL) {
  op <- new_operation(
    name = "SendEmail",
    http_method = "POST",
    http_path = "/v2/email/outbound-emails",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$send_email_input(FromEmailAddress = FromEmailAddress, FromEmailAddressIdentityArn = FromEmailAddressIdentityArn, Destination = Destination, ReplyToAddresses = ReplyToAddresses, FeedbackForwardingEmailAddress = FeedbackForwardingEmailAddress, FeedbackForwardingEmailAddressIdentityArn = FeedbackForwardingEmailAddressIdentityArn, Content = Content, EmailTags = EmailTags, ConfigurationSetName = ConfigurationSetName, EndpointId = EndpointId, ListManagementOptions = ListManagementOptions)
  output <- .sesv2$send_email_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$send_email <- sesv2_send_email

#' Add one or more tags (keys and values) to a specified resource
#'
#' @description
#' Add one or more tags (keys and values) to a specified resource. A *tag* is a label that you optionally define and associate with a resource. Tags can help you categorize and manage resources in different ways, such as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_tag_resource/](https://www.paws-r-sdk.com/docs/sesv2_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to add one
#' or more tags to.
#' @param Tags &#91;required&#93; A list of the tags that you want to add to the resource. A tag consists
#' of a required tag key (`Key`) and an associated tag value (`Value`). The
#' maximum length of a tag key is 128 characters. The maximum length of a
#' tag value is 256 characters.
#'
#' @keywords internal
#'
#' @rdname sesv2_tag_resource
sesv2_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v2/email/tags",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .sesv2$tag_resource_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$tag_resource <- sesv2_tag_resource

#' Creates a preview of the MIME content of an email when provided with a
#' template and a set of replacement data
#'
#' @description
#' Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_test_render_email_template/](https://www.paws-r-sdk.com/docs/sesv2_test_render_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the template.
#' @param TemplateData &#91;required&#93; A list of replacement values to apply to the template. This parameter is
#' a JSON object, typically consisting of key-value pairs in which the keys
#' correspond to replacement tags in the email template.
#'
#' @keywords internal
#'
#' @rdname sesv2_test_render_email_template
sesv2_test_render_email_template <- function(TemplateName, TemplateData) {
  op <- new_operation(
    name = "TestRenderEmailTemplate",
    http_method = "POST",
    http_path = "/v2/email/templates/{TemplateName}/render",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$test_render_email_template_input(TemplateName = TemplateName, TemplateData = TemplateData)
  output <- .sesv2$test_render_email_template_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$test_render_email_template <- sesv2_test_render_email_template

#' Remove one or more tags (keys and values) from a specified resource
#'
#' @description
#' Remove one or more tags (keys and values) from a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_untag_resource/](https://www.paws-r-sdk.com/docs/sesv2_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to remove
#' one or more tags from.
#' @param TagKeys &#91;required&#93; The tags (tag keys) that you want to remove from the resource. When you
#' specify a tag key, the action removes both that key and its associated
#' tag value.
#' 
#' To remove more than one tag from the resource, append the `TagKeys`
#' parameter and argument for each additional tag to remove, separated by
#' an ampersand. For example:
#' `/v2/email/tags?ResourceArn=ResourceArn&TagKeys=Key1&TagKeys=Key2`
#'
#' @keywords internal
#'
#' @rdname sesv2_untag_resource
sesv2_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v2/email/tags",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .sesv2$untag_resource_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$untag_resource <- sesv2_untag_resource

#' Update the configuration of an event destination for a configuration set
#'
#' @description
#' Update the configuration of an event destination for a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_update_configuration_set_event_destination/](https://www.paws-r-sdk.com/docs/sesv2_update_configuration_set_event_destination/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that contains the event destination to
#' modify.
#' @param EventDestinationName &#91;required&#93; The name of the event destination.
#' @param EventDestination &#91;required&#93; An object that defines the event destination.
#'
#' @keywords internal
#'
#' @rdname sesv2_update_configuration_set_event_destination
sesv2_update_configuration_set_event_destination <- function(ConfigurationSetName, EventDestinationName, EventDestination) {
  op <- new_operation(
    name = "UpdateConfigurationSetEventDestination",
    http_method = "PUT",
    http_path = "/v2/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$update_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName, EventDestination = EventDestination)
  output <- .sesv2$update_configuration_set_event_destination_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$update_configuration_set_event_destination <- sesv2_update_configuration_set_event_destination

#' Updates a contact's preferences for a list
#'
#' @description
#' Updates a contact's preferences for a list.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_update_contact/](https://www.paws-r-sdk.com/docs/sesv2_update_contact/) for full documentation.
#'
#' @param ContactListName &#91;required&#93; The name of the contact list.
#' @param EmailAddress &#91;required&#93; The contact's email address.
#' @param TopicPreferences The contact's preference for being opted-in to or opted-out of a topic.
#' @param UnsubscribeAll A boolean value status noting if the contact is unsubscribed from all
#' contact list topics.
#' @param AttributesData The attribute data attached to a contact.
#'
#' @keywords internal
#'
#' @rdname sesv2_update_contact
sesv2_update_contact <- function(ContactListName, EmailAddress, TopicPreferences = NULL, UnsubscribeAll = NULL, AttributesData = NULL) {
  op <- new_operation(
    name = "UpdateContact",
    http_method = "PUT",
    http_path = "/v2/email/contact-lists/{ContactListName}/contacts/{EmailAddress}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$update_contact_input(ContactListName = ContactListName, EmailAddress = EmailAddress, TopicPreferences = TopicPreferences, UnsubscribeAll = UnsubscribeAll, AttributesData = AttributesData)
  output <- .sesv2$update_contact_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$update_contact <- sesv2_update_contact

#' Updates contact list metadata
#'
#' @description
#' Updates contact list metadata. This operation does a complete replacement.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_update_contact_list/](https://www.paws-r-sdk.com/docs/sesv2_update_contact_list/) for full documentation.
#'
#' @param ContactListName &#91;required&#93; The name of the contact list.
#' @param Topics An interest group, theme, or label within a list. A contact list can
#' have multiple topics.
#' @param Description A description of what the contact list is about.
#'
#' @keywords internal
#'
#' @rdname sesv2_update_contact_list
sesv2_update_contact_list <- function(ContactListName, Topics = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateContactList",
    http_method = "PUT",
    http_path = "/v2/email/contact-lists/{ContactListName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$update_contact_list_input(ContactListName = ContactListName, Topics = Topics, Description = Description)
  output <- .sesv2$update_contact_list_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$update_contact_list <- sesv2_update_contact_list

#' Updates an existing custom verification email template
#'
#' @description
#' Updates an existing custom verification email template.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_update_custom_verification_email_template/](https://www.paws-r-sdk.com/docs/sesv2_update_custom_verification_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the custom verification email template that you want to
#' update.
#' @param FromEmailAddress &#91;required&#93; The email address that the custom verification email is sent from.
#' @param TemplateSubject &#91;required&#93; The subject line of the custom verification email.
#' @param TemplateContent &#91;required&#93; The content of the custom verification email. The total size of the
#' email must be less than 10 MB. The message body may contain HTML, with
#' some limitations. For more information, see [Custom verification email
#' frequently asked
#' questions](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom-faq)
#' in the *Amazon SES Developer Guide*.
#' @param SuccessRedirectionURL &#91;required&#93; The URL that the recipient of the verification email is sent to if his
#' or her address is successfully verified.
#' @param FailureRedirectionURL &#91;required&#93; The URL that the recipient of the verification email is sent to if his
#' or her address is not successfully verified.
#'
#' @keywords internal
#'
#' @rdname sesv2_update_custom_verification_email_template
sesv2_update_custom_verification_email_template <- function(TemplateName, FromEmailAddress, TemplateSubject, TemplateContent, SuccessRedirectionURL, FailureRedirectionURL) {
  op <- new_operation(
    name = "UpdateCustomVerificationEmailTemplate",
    http_method = "PUT",
    http_path = "/v2/email/custom-verification-email-templates/{TemplateName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$update_custom_verification_email_template_input(TemplateName = TemplateName, FromEmailAddress = FromEmailAddress, TemplateSubject = TemplateSubject, TemplateContent = TemplateContent, SuccessRedirectionURL = SuccessRedirectionURL, FailureRedirectionURL = FailureRedirectionURL)
  output <- .sesv2$update_custom_verification_email_template_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$update_custom_verification_email_template <- sesv2_update_custom_verification_email_template

#' Updates the specified sending authorization policy for the given
#' identity (an email address or a domain)
#'
#' @description
#' Updates the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_update_email_identity_policy/](https://www.paws-r-sdk.com/docs/sesv2_update_email_identity_policy/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email identity.
#' @param PolicyName &#91;required&#93; The name of the policy.
#' 
#' The policy name cannot exceed 64 characters and can only include
#' alphanumeric characters, dashes, and underscores.
#' @param Policy &#91;required&#93; The text of the policy in JSON format. The policy cannot exceed 4 KB.
#' 
#' For information about the syntax of sending authorization policies, see
#' the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/).
#'
#' @keywords internal
#'
#' @rdname sesv2_update_email_identity_policy
sesv2_update_email_identity_policy <- function(EmailIdentity, PolicyName, Policy) {
  op <- new_operation(
    name = "UpdateEmailIdentityPolicy",
    http_method = "PUT",
    http_path = "/v2/email/identities/{EmailIdentity}/policies/{PolicyName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$update_email_identity_policy_input(EmailIdentity = EmailIdentity, PolicyName = PolicyName, Policy = Policy)
  output <- .sesv2$update_email_identity_policy_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$update_email_identity_policy <- sesv2_update_email_identity_policy

#' Updates an email template
#'
#' @description
#' Updates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sesv2_update_email_template/](https://www.paws-r-sdk.com/docs/sesv2_update_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the template.
#' @param TemplateContent &#91;required&#93; The content of the email template, composed of a subject line, an HTML
#' part, and a text-only part.
#'
#' @keywords internal
#'
#' @rdname sesv2_update_email_template
sesv2_update_email_template <- function(TemplateName, TemplateContent) {
  op <- new_operation(
    name = "UpdateEmailTemplate",
    http_method = "PUT",
    http_path = "/v2/email/templates/{TemplateName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sesv2$update_email_template_input(TemplateName = TemplateName, TemplateContent = TemplateContent)
  output <- .sesv2$update_email_template_output()
  config <- get_config()
  svc <- .sesv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sesv2$operations$update_email_template <- sesv2_update_email_template
