% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_create_user}
\alias{elasticache_create_user}
\title{For Valkey engine version 7}
\usage{
elasticache_create_user(
  UserId,
  UserName,
  Engine,
  Passwords = NULL,
  AccessString,
  NoPasswordRequired = NULL,
  Tags = NULL,
  AuthenticationMode = NULL
)
}
\arguments{
\item{UserId}{[required] The ID of the user.}

\item{UserName}{[required] The username of the user.}

\item{Engine}{[required] The current supported value is Redis.}

\item{Passwords}{Passwords used for this user. You can create up to two passwords for
each user.}

\item{AccessString}{[required] Access permissions string used for this user.}

\item{NoPasswordRequired}{Indicates a password is not required for this user.}

\item{Tags}{A list of tags to be added to this resource. A tag is a key-value pair.
A tag key must be accompanied by a tag value, although null is accepted.}

\item{AuthenticationMode}{Specifies how to authenticate the user.}
}
\description{
For Valkey engine version 7.2 onwards and Redis OSS 6.0 and onwards: Creates a user. For more information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Clusters.RBAC.html}{Using Role Based Access Control (RBAC)}.

See \url{https://www.paws-r-sdk.com/docs/elasticache_create_user/} for full documentation.
}
\keyword{internal}
